/*=============================================================================================
        section 1 - includes
 ==============================================================================================*/
/* imported libs */
#include "mbed.h"
#include "F746_GUI.hpp"

/* project files */
#include "relay.h"
#include "flash.h"

/*=============================================================================================
        section 2 - private defines / enumerations
 ==============================================================================================*/

/*=============================================================================================
        section 3 - private typedefs
 ==============================================================================================*/

/*=============================================================================================
        section 4 - private macros
 ==============================================================================================*/
 
/*=============================================================================================
        section 5 - public constants definition
 ==============================================================================================*/

/*=============================================================================================
        section 6 - public variables/pointers definition
 ==============================================================================================*/
/* definition public variables  */

/* definition public pointers */

/*=============================================================================================
        section 7 - private constants definition
 ==============================================================================================*/

/*=============================================================================================
        section 8 - private variables/objects/pointers definition
 ==============================================================================================*/
/* definition private variables  */

/* definition private pointers */
static Label   *pLabelLight1;
static Button  *pBtnLight1;
static Label   *pLabelLight2;
static Button  *pBtnLight2;

/*=============================================================================================
        section 9 - private functions - declaration
 ==============================================================================================*/

/*=============================================================================================
        section 10 - private functions - implementation (definition)
 ==============================================================================================*/

/*=============================================================================================
        section 11 - public functions - implementation (definition)
 ==============================================================================================*/
void relay_init(void) 
{
    pLabelLight1    = new Label(  10, 40 + 12,  "Lampe 1: ", Label::LEFT, Font16);
    pBtnLight1      = new Button(100, 40, 70, 40, "schalten");
    pLabelLight2    = new Label(  10, 90 + 12, "Lampe 2: ", Label::LEFT, Font16);
    pBtnLight2      = new Button(100, 90, 70, 40, "schalten");
}

void relay_switch(E_RELAY_LIGHT lightNumber)
{
    DigitalOut  *out1;
    DigitalOut  *out2;
    uint8_t     toggleByte;
    
    if (lightNumber == RELAY_LIGHT1)
    {
        out1        = &g_light1Fet1;
        out2        = &g_light1Fet2;
        toggleByte  = flash_read(FLASH_TOGGLE_BYTE_LIGHT1);
        toggleByte  = !toggleByte;
        flash_write(FLASH_TOGGLE_BYTE_LIGHT1, toggleByte);
    } 
    else if (lightNumber == RELAY_LIGHT2)
    {
        out1        = &g_light2Fet1;
        out2        = &g_light2Fet2;
        toggleByte  = flash_read(FLASH_TOGGLE_BYTE_LIGHT2);
        toggleByte  = !toggleByte;
        flash_write(FLASH_TOGGLE_BYTE_LIGHT2, toggleByte);
    }
    
    /* Je nach Stellung des toggle Bytes,
       wird Ausgang 1 oder 2 kurzzeitig geschaltet (Spannung angelegt). */
    if(toggleByte) 
    {
        out1->write(1);
        wait(0.5);
        out1->write(0);
    } 
    else 
    {
        out2->write(1);
        wait(0.5);
        out2->write(0);
    }  
}

void relay_task(void)
{
    /* Objekte nicht initialisiert => Fehler */
    if ((pBtnLight1 == NULL) ||
        (pBtnLight2 == NULL))
    {
        return;    
    }
    
    /* prüft ob button "pBtnLight1" gerade gedrück ist */  
    if (pBtnLight1->Touched()) 
    {
        relay_switch(RELAY_LIGHT1);
        pBtnLight1->Draw();
    }
    
    /* prüft ob button "pBtnLight2" gerade gedrück ist */  
    if (pBtnLight2->Touched()) 
    {
        relay_switch(RELAY_LIGHT2);
        pBtnLight2->Draw();
    }
}
/*=============================================================================================
        section 12 - interrupt service routines (ISRs)
 ==============================================================================================*/

/*=============================================================================================
        end of file
 ==============================================================================================*/