/*=============================================================================================
        section 1 - includes
 ==============================================================================================*/
/* imported libs */
#include "mbed.h"
#include "F746_GUI.hpp"

/* project files */
#include "relay.h"
#include "flash.h"
#include "lightAutomatic.h"

/*=============================================================================================
        section 2 - private defines / enumerations
 ==============================================================================================*/

/*=============================================================================================
        section 3 - private typedefs
 ==============================================================================================*/

/*=============================================================================================
        section 4 - private macros
 ==============================================================================================*/
 
/*=============================================================================================
        section 5 - public constants definition
 ==============================================================================================*/

/*=============================================================================================
        section 6 - public variables/pointers definition
 ==============================================================================================*/
/* inputs */
DigitalIn g_doorSensor(D3, PullUp);
DigitalIn g_lightSensor(D2, PullDown);

/* outputs */
DigitalOut g_light1Fet1(D4, 0);
DigitalOut g_light1Fet2(D5, 0);
DigitalOut g_light2Fet1(D6, 0);
DigitalOut g_light2Fet2(D7, 0);

/*=============================================================================================
        section 7 - private constants definition
 ==============================================================================================*/

/*=============================================================================================
        section 8 - private variables/objects/pointers definition
 ==============================================================================================*/

/*=============================================================================================
        section 9 - private functions - declaration
 ==============================================================================================*/

/*=============================================================================================
        section 10 - private functions - implementation (definition)
 ==============================================================================================*/

/*=============================================================================================
        section 11 - public functions - implementation (definition)
 ==============================================================================================*/
int main() 
{      
    /* GUI Ojects */
    Label labelTop(240, 2, "Display Steuerung v0.2", Label::CENTER, Font16);

    /***************************
     init 
     ***************************/   
    relay_init();
    flash_init();    
    lightAutomatic_init(); 
    
    /***************************
     main loop 
     ***************************/
    while(1) 
    { 
        relay_task();
        lightAutomatic_task();
        flash_task();
    }
}

/*=============================================================================================
        section 12 - interrupt service routines (ISRs)
 ==============================================================================================*/

/*=============================================================================================
        end of file
 ==============================================================================================*/