//
//  Scissors.cpp
//  
//
//  Created by steve daniels on 12-08-19.
//  Copyright (c) 2012 __ribosome.ca__. All rights reserved.
//


#include <Scissors.h>
#include <string.h>
#include "mbed.h"
#include "m3pi.h"
#include <stdlib.h>




Scissors::Scissors() {
       // constructor
       m3pi pi;
       init('*', '#', ',');
}


/*
NOTE:  change this to set baud -- mBed very diff than Ard
void Scissors::begin( int _baud )
{
    init( _baud, '*', '#', ',' ); // specified baud, default parse parameters
}
*/

/*
void Scissors::begin( Serial _passedSerial, char _start_byte, char _end_byte, char _delimiter )
{
    init( _start_byte,  _end_byte,  _delimiter); // user specifies all terms
}

*/

void Scissors::init( char _start_byte, char _end_byte, char _delimiter)
{
   
    START_BYTE = _start_byte;
    END_BYTE   = _end_byte;
    DELIMITER  = _delimiter;
    MAX_ELEMENTS = 8;
    
    elementCount =  0;
    messageStart = -1;
    messageEnd   = -1;
    //delims[MAX_ELEMENTS+1]        ; //   [MAX_ELEMENTS+1]   array to hold delimiter locations in buffer string
    
    
}

// new strategy -- Scissors just gets strings and eats them

int Scissors::cut( char * _m ) {

  messageBuffer =_m;
  //strcpy ( messageBuffer, _m ); // dest, source
  
  //printTest(messageBuffer);

  int state = 0;
   
  messageStart = -1;
  messageEnd   = -1;
    
    //wait(0.1);  // for reasons I don't understand this is really important -- do not remove
    

  // we have a message so I cut out all the get the message stuff

   // a bit of error checking
   // go through and find location of START_BYTE and END_BYTE
   int start = -1;
   int end = -1;
   int lastDelim = -1;
   
    //int s = messageBuffer.indexOf(START_BYTE);
   for (int i = 0; i < strlen(messageBuffer); i ++ ) {
         if ( messageBuffer[i] == START_BYTE ) {
            start = i;
         }
         
         if ( messageBuffer[i] == END_BYTE ) {
            end = i;
         }
         
    } // end for 
    
    //int e = messageBuffer.indexOf(END_BYTE);
    
     for (int i = end; i >=0 ; i -- ) {
             pi.locate(0,0);
             pi.printf("i = %d : ",i);
         if ( messageBuffer[i] == DELIMITER ) {
            lastDelim = i;
             //wait(1);
            break;
         }
    } // end for 
    
        
        //int e = messageBuffer.lastIndexOf(DELIMITER);
        
   if (lastDelim <= 0) { // did not find a delimiter
    
        // so, check for an end byte, some messages do not have DELIMITERS
          lastDelim = end;

    }  // end if 
    
   if (start >= 0 ) { 
 
     messageStart = start;

     if (lastDelim > start)  {     
         messageEnd = lastDelim;
        // appear to have a whole message -- reset parse values
        // messageEnd = messageBuffer.lastIndexOf(DELIMITER);
        // memset( delims, 0, ( sizeof(delims) / sizeof(delims[0]) ) ); // clear delims array for new values
      
         state = findDelimiters();

       //wait(1);

       
     } // end e>s
     else {
      state = -2; // no end found 
     }
     
   } // end s>=0
   else {
     state = -1; // no start  
   }
      /*
      pi.cls();
             pi.locate(0,0);
             pi.printf("s/e %d %d ", start, end );
             pi.locate(0,1);
             pi.printf(",t %d %d ",lastDelim, state);
             wait(1);
             */
             
  return state;
  
}


int Scissors::findDelimiters() {

pi.cls();
pi.locate(0,0);
pi.printf("find D's");
//wait(1);

    // delims array stores locations of DELIMITERS -- there 
          elementCount = 0;
          delims[elementCount] = messageStart;     
             pi.cls();
pi.locate(0,0);
pi.printf("D's @");
//wait(1);
pi.locate(0,1);
pi.printf("%d ", messageStart);

          for (int i = messageStart+1; i <= messageEnd;  i ++) {  
            
            if (elementCount > MAX_ELEMENTS) break; // message is longer than max -- overflow
                                                     // this overflow is not YET signalled
            if ( (messageBuffer[i] == DELIMITER)   ) { 
                  
                  elementCount ++; 
                  delims[elementCount] = i ;
                  pi.printf("%d ", i);
                  if (messageBuffer[i+1] == END_BYTE) break;
                  
            } // end if         
            
            
          } // end for 

        // we are at end of message -- if elementCount still == 0 then there were no delimiters
        // however, we can only be here if we had an end byte after a start byte -- 
        // SO, there must be a single undelimited ELEMENT in the message 
        if ( elementCount == 0 ) {
        //  Serial.println("no delims");
            elementCount = 1;
            delims[1] = messageEnd;
        }
        
   
   return elementCount;

}  // end parser

void clearSub(){
   
}

char * Scissors::getElement ( int whichOne ){  // not called directly by user
 
  //clearSub();
  //sprintf(sub, "%s","  ");
  for (int j = 0 ; j < 144; j++) sub[j] ='\0';
     
 
  int subCount = 0;

  if ( (whichOne >= 0) && (whichOne <= elementCount) ) 
  
  {
    
      int startLoc = delims[whichOne]+1 ;
      int endLoc   = delims[whichOne+1] ;
   
      
      if ( startLoc > endLoc ) // START_BYTE comes after END_BYTE
      {  
          pi.cls();
          pi.locate(0,1);
  
          pi.printf( "err: Sb4E" );
        
          
      } 
      else {  // START_BYTE preceeds END_BYTE
        
        
         for (int c = startLoc ;  c < endLoc ; c++ ) 
         {
          sub[subCount] = messageBuffer[c];
          subCount++;
         }
        
       
      } // end else
 
     
  } 
  else {
   
     printTest("eek");
    
     //sub = "err: ElOoR"; // element out of range
     sprintf(sub,"err: ElOoR");
  }
   //printTest(sub);
   return sub;
  
} // end getElement



int Scissors::getInt ( int whichOne ){
   
    // http://www.cplusplus.com/reference/clibrary/cstdlib/atoi/
    // no standard way to solve issue of STRING input not being in range of INT
    // this will fail QUITELY!!!!

    int lowIndex = 0;
    
    char * elementString = getElement(whichOne);
   
  
        // check for neg -- without this we reject neg values
        if ( elementString[0] == '-' )  {   
            lowIndex = 1;
        }

      if ( ( elementString[lowIndex] <'0' ||elementString[0] > '9') ) {
        return -9998;
      }

     return atoi(elementString);

}



float Scissors::getFloat( int whichOne ) {
  
  int lowIndex = 0;
    
  char * elementString = getElement(whichOne);
   
    // check for neg -- without this we reject neg values
    if ( elementString[0] == '-' )  {   
            lowIndex = 1;
            wait(0.01);
    }

      if (elementString[lowIndex] <'0' || elementString[0] > '9') {
        //Serial.println("NaN");
        return -9999;
      }
  
  return atof(elementString); 
  
  

}



char * Scissors::getString (int whichOne) {
  return getElement(whichOne);
}


char * Scissors::getRaw() {
   return messageBuffer; 
}



int Scissors::setStartByte(char s) {
  START_BYTE = s;
  return 1;
}


int Scissors::setEndByte(char e) {
  END_BYTE = e;
  return 1;
  
}


int Scissors::setDelimiter(char d) {
  DELIMITER = d;
  return 1;
  
}

int Scissors::setMaxElements( int m ) {
    MAX_ELEMENTS = m;
    delims[MAX_ELEMENTS+1];    
    return 1; 
}


char Scissors::getStartByte( ) {
   return START_BYTE;
}


char Scissors::getEndByte( ) {
   return END_BYTE;
}


char Scissors::getDelimiter( ) {
   return DELIMITER;
}


int Scissors::getMaxElements(  ) { 
    return  MAX_ELEMENTS ; 
}

int Scissors::getBaud(){
    
    return BAUD ;
}



void Scissors::printTest ( char * _t ){
   pi.cls();
   pi.locate(0,0);
   pi.printf(_t);
   wait(2);
    
}



