//
//  Scissors.h
//  
//
//  Created by steve daniels on 12-08-19.
//  Copyright (c) 2012 __ribosome.ca__. All rights reserved.
//


#ifndef Scissors_h
#define Scissors_h
#include <string>

#include "mbed.h"
#include "m3pi.h"



class Scissors
{
    
public: 
    
   char * messageBuffer; 
   char  sub[144];
   
   m3pi pi;


    
    // constructors
    Scissors();

    // parse functions
    int cut ( char * );
    int    update    ( );
    int    getInt    ( int );
    float  getFloat  ( int );
    char * getString ( int );
    char * getRaw    ( );
    
    void printTest ( char *  );
    void clearSub (  );
    
    // setters
    int setStartByte( char );
    int setEndByte  ( char );
    int setDelimiter( char );
    int setMaxElements( int ) ;
    
        
    // getters
    char getStartByte   ( );
    char getEndByte     ( );
    char getDelimiter   ( );
    int  getMaxElements ( ); 
    int  getBaud        ( );


    
    // internal vars & parsing variables
    char START_BYTE;
    char END_BYTE  ;
    char DELIMITER ;  
    int  MAX_ELEMENTS;
    int  BAUD ;
    
private:
       
       
    int elementCount ; //=  0;
    int messageStart ; // = -1;
    int messageEnd   ; // = -1;
    int delims[9]   ; //   [MAX_ELEMENTS+1]   array to hold delimiter locations in buffer string
    
    // buffers for incoming data ( yes they could be a char[] -- but they arn't )

    
    void init (char, char, char);
    int findDelimiters();
    char * getElement ( int ) ; // not called directly by user
    
   
    
}; //endclass Scissors


#endif
