#include "mbed.h"

//演示定时器中断如何使用

Ticker toggle_led_ticker;   //声明一个 Ticker 对象

DigitalOut led1(LED1);

void toggle_led() {        //中断子程序,在平衡车和无人机的项目中,控制算法就写在中断子程序中:获取陀螺仪数据,根据陀螺仪数据通过PID算法得到电机的控制量(占空比和方向),在输出到单片机管脚
    led1 = !led1;
}

int main() {
    // Init the ticker with the address of the function (toggle_led) to be attached and the interval (100 ms)
    toggle_led_ticker.attach(&toggle_led, 0.1);     //指定Ticker 对象的回调函数也就是中断子程序以及  中断的时间间隔即每隔多久执行一次,一般0.02或0.01即可
    while (true) {
        // Do other things...
    }
}