#include "mbed.h"
#include "mpu6050.h" 


DigitalOut myled(LED1);
Serial pc(SERIAL_TX, SERIAL_RX);
Ticker pid_ticker;   //声明一个 Ticker 对象

void pid_calculator();

float pitch,roll,yaw;       //欧拉角
unsigned int filure_counter = 0;
unsigned int SystemTick = 0;

int main() {
    
        int time_now = 0;
    
        pid_ticker.attach(&pid_calculator, 0.01);   //中断跑在100Hz，因为6050也是以100Hz刷新
    
    
    MPU_Init();                 //初始化MPU6050
    myled = 0;
    while(mpu_dmp_init())
    {
        wait(0.2);
        myled = !myled;
    }    
    while(1)
    {
            //检测读取数据失败的次数 如感觉6050读数存在问题运行此段代码检查 串口打印的是每1s内 数据获取失败的次数
            /*if((SystemTick - time_now) >= 100)   
            {
                time_now = SystemTick;
                pc.printf("%d\r\n", filure_counter);
                filure_counter = 0;
            }*/
            
            
            pc.printf("pitch: %.2f roll: %.2f yaw: %.2f\r\n", pitch,roll,yaw);
    }   
}

void pid_calculator()   //更新当前姿态 运行PID算法 
{
    SystemTick++;
    if(SystemTick >= 5000)
        SystemTick = 0;
    if(mpu_dmp_get_data(&pitch,&roll,&yaw) != 0)
        filure_counter++;
}
