#include "GUI.h"

void RefreshGUI(Serial *Screen, float Servo1, float Servo2, float Servo3, float Servo4, float Servo5, float Servo6, float Bar1, float Bar2, float Bar3, float Bar4, float Bar5, float Bar6)
{
    SXY(Screen,8,35);
    DS16(Screen,90,20,float2string(Servo1),3);
    DS16(Screen,90,40,float2string(Servo2),3);
    DS16(Screen,90,60,float2string(Servo3),3);
    DS16(Screen,90,80,float2string(Servo4),3);
    DS16(Screen,90,100,float2string(Servo5),3);
    DS16(Screen,90,120,float2string(Servo6),3);
    
    SXY(Screen,170,35);
    DS16(Screen,90,20,float2string(Bar1),3);
    DS16(Screen,90,40,float2string(Bar2),3);
    DS16(Screen,90,60,float2string(Bar3),3);
    DS16(Screen,90,80,float2string(Bar4),3);
    DS16(Screen,90,100,float2string(Bar5),3);
    DS16(Screen,90,120,float2string(Bar6),3);

    SXY(Screen,0,0);
    ExecuteInstruction(Screen);
    wait(0.1);
}

void InitGUI(Serial *Screen)
{
    SXY(Screen,0,0);
    CLS(Screen,0);
    DS24(Screen,30,2,"Stewart Platform GUI v1.0",12);
    PL(Screen,0,28,319,28,15);
    PL(Screen,0,29,319,29,15);
    PL(Screen,159,35,159,190,15);
    PL(Screen,160,35,160,190,15);
    SXY(Screen,8,35);
    DS16(Screen,30,0,"Servo Angle",2);
    DS16(Screen,0,20,"Servo1",2);
    DS16(Screen,0,40,"Servo2",2);
    DS16(Screen,0,60,"Servo3",2);
    DS16(Screen,0,80,"Servo4",2);
    DS16(Screen,0,100,"Servo5",2);
    DS16(Screen,0,120,"Servo6",2);
    DS16(Screen,5,140,"[For structure I]",2);
    
    SXY(Screen,170,35);
    DS16(Screen,35,0,"Bar Length",2);
    DS16(Screen,0,20,"Bar1",2);
    DS16(Screen,0,40,"Bar2",2);
    DS16(Screen,0,60,"Bar3",2);
    DS16(Screen,0,80,"Bar4",2);
    DS16(Screen,0,100,"Bar5",2);
    DS16(Screen,0,120,"Bar6",2);
    DS16(Screen,2,140,"[For structure II]",2);
    SXY(Screen,0,0);
    PL(Screen,0,195,319,195,15);
    PL(Screen,0,196,319,196,15);
    DS24(Screen,100,198,"THU iCenter",12);
    DS16(Screen,50,222,"Developed by C.H. Dep of EEA",2);
    SXY(Screen,0,0);
    ExecuteInstruction(Screen);
    wait(0.2);
}

void DS16(Serial *Screen, int x, int y, string str, int color)
{
    string temp = "DS16("+int2string(x)+","+int2string(y)+",'"+str+"',"+int2string(color)+");";
    Screen->printf(temp.c_str());
}

void DS24(Serial *Screen, int x, int y, string str, int color)
{
    string temp = "DS24("+int2string(x)+","+int2string(y)+",'"+str+"',"+int2string(color)+");";
    Screen->printf(temp.c_str());
}

void SXY(Serial *Screen, int x, int y)
{
    string temp = "SXY("+int2string(x)+","+int2string(y)+");";
    Screen->printf(temp.c_str());
}

void CLS(Serial *Screen, int color)
{
    string temp = "CLS("+int2string(color)+");";
    Screen->printf(temp.c_str());
}

void PL(Serial *Screen, int x1, int y1, int x2, int y2, int color)
{
    string temp = "PL("+int2string(x1)+","+int2string(y1)+","+int2string(x2)+","+int2string(y2)+","+int2string(color)+");";
    Screen->printf(temp.c_str());
}

void ExecuteInstruction(Serial *Screen)
{
    Screen->printf("\r\n");
}

string int2string(int x)
{
    stringstream ss;
    ss << x;
    string str = ss.str();
    return str;
}

string float2string(float x)
{
    int xx = x * 100;
    float xxx = (float)xx / 100;
    stringstream ss;
    ss << xxx;
    string str = ss.str() + ' ';
    return str;
}

 
