#include "mbed.h"
#include <stdio.h>
#include <stdlib.h>
#include <math.h> 
#include "StewartPlatform.h"
DigitalOut myled(LED1);
Serial pc(SERIAL_TX, SERIAL_RX);
StewartPlatformType Platform;                                           //动感平台数据结构体 

int main() 
{
    while(1) 
    {
        myled = 1; // LED is ON
        wait(0.2); // 200 ms
        myled = 0; // LED is OFF
        wait(1.0); // 1 sec
        
        
        Platform.topRadius = 244.95;                                            //平台参数初始化 
        Platform.topInterval = 100;
        Platform.bottomRadius = 332.54;
        Platform.bottomInterval = 340;
        Platform.lengthOfSteelWheel = 150;
        Platform.lengthOfCardan = 150;
        Platform.lengthOfBar = 368;
        Platform.x = 25;                                                        //设定上平台姿态 
        Platform.y = 31;
        Platform.z = 278;
        Platform.a = 15;
        Platform.b = 12;
        Platform.c = 22;
        CalStewartPlatform(&Platform);                                          //解析平台数据 
        pc.printf("Angle: %.2f %.2f %.2f %.2f %.2f %.2f \r\n", Platform.theta[0], Platform.theta[1], Platform.theta[2], Platform.theta[3], Platform.theta[4], Platform.theta[5]);
        pc.printf("Servo Angle: %.2f %.2f %.2f %.2f %.2f %.2f \r\n", Platform.theta_servo[0], Platform.theta_servo[1], Platform.theta_servo[2], Platform.theta_servo[3], Platform.theta_servo[4], Platform.theta_servo[5]);
        pc.printf("BarLength: %.2f %.2f %.2f %.2f %.2f %.2f \r\n", Platform.BarLength[0], Platform.BarLength[1], Platform.BarLength[2], Platform.BarLength[3], Platform.BarLength[4], Platform.BarLength[5]);
    }
}
