#include "GUI.h"

int screen_buf1[140] = {};

int screen_buf2[140] = {};

int index = 0;

void RefreshGUI(Serial *Screen, int freq, float kp, float ki, int goal, int pos)
{
    unsigned long int long_goal, long_pos;
    long_goal = goal;
    long_pos = pos;
    SXY(Screen,8,35);
    if(freq < 10)
        DS16(Screen,90,20,int2string(freq)+"    ",3);
    else
        DS16(Screen,90,20,int2string(freq)+" ",3);
    DS16(Screen,90,40,float2string(kp),3);
    DS16(Screen,90,60,float2string(ki),3);
    DS16(Screen,90,80,int2string(goal)+" ",3);
    DS16(Screen,90,100,int2string(pos)+"  ",3);
    
    SXY(Screen,170,75);
    PS(Screen,index,screen_buf1[index],0);
    //screen_buf1[index] = 110-long_goal/(16383/110);
    screen_buf1[index] = 110-goal/(16383/110);
    PS(Screen,index,screen_buf1[index],3);
    PS(Screen,index,screen_buf2[index],0);
    //screen_buf1[index] = 110-long_pos/(16383/110);
    screen_buf2[index] = 110-pos/(16383/110);
    PS(Screen,index,screen_buf2[index],5);
    index++;
    if(index == 140)
        index = 0;


    SXY(Screen,0,0);
    ExecuteInstruction(Screen);
    //wait(0.1);
}

void InitGUI(Serial *Screen)
{
    char c1[18]={0xB1,0xD5,0xBB,0xB7,0xB2,0xBD,0xBD,0xF8,0xB5,0xE7,0xBB,0xFA,0xCA,0xD4,0xD1,0xE9,0xCC,0xA8};//闭环步进电机试验台
    char c2[8]={0xBF,0xD8,0xD6,0xC6,0xD0,0xC5,0xCF,0xA2};//控制信息
    char c3[4]={0xC6,0xB5,0xC2,0xCA};//频率
    char c4[8]={0xB1,0xC8,0xC0,0xFD,0xCF,0xB5,0xCA,0xFD};//比例系数
    char c5[8]={0xBB,0xFD,0xB7,0xD6,0xCF,0xB5,0xCA,0xFD};//积分系数
    char c6[8]={0xC4,0xBF,0xB1,0xEA,0xCE,0xBB,0xD6,0xC3};//目标位置
    char c7[8]={0xB5,0xB1,0xC7,0xB0,0xCE,0xBB,0xD6,0xC3};//当前位置
    char c8[18] = {0xC7,0xE5,0xBB,0xAA,0xB4,0xF3,0xD1,0xA7,0xB4,0xB4,0xD0,0xC2,0xB9,0xA4,0xD7,0xF7,0xB7,0xBB};//清华大学创新工作坊
    string str= "";

    SXY(Screen,0,0);
    CLS(Screen,0);
    for(int i=0;i<18;i++) str+=c1[i];
    DS16(Screen,90,4,str,12);
    str= "";
    PL(Screen,0,28,319,28,15);
    PL(Screen,0,29,319,29,15);
    PL(Screen,159,35,159,190,15);
    PL(Screen,160,35,160,190,15);
    SXY(Screen,8,35);
    for(int i=0;i<8;i++) str+=c2[i];
    DS16(Screen,30,0,str,2);
    str= "";
    for(int i=0;i<4;i++) str+=c3[i];
    DS16(Screen,0,20,str,2);
    str= "";
    for(int i=0;i<8;i++) str+=c4[i];
    DS16(Screen,0,40,str,2);
    str= "";
    for(int i=0;i<8;i++) str+=c5[i];
    DS16(Screen,0,60,str,2);
    str= "";
    for(int i=0;i<8;i++) str+=c6[i];
    DS16(Screen,0,80,str,2);
    str= "";
    for(int i=0;i<8;i++) str+=c7[i];
    DS16(Screen,0,100,str,2);
    str= "";
    
    SXY(Screen,170,35);
    for(int i=0;i<8;i++) str+=c6[i];
    DS16(Screen,0,0,str,2);
    str= "";
    for(int i=0;i<8;i++) str+=c7[i];
    DS16(Screen,0,20,str,2);
    str= "";
    PL(Screen,80,5,140,5,3);
    PL(Screen,80,6,140,6,3);
    PL(Screen,80,25,140,25,5);
    PL(Screen,80,26,140,26,5);
    SXY(Screen,0,0);
    PL(Screen,0,195,319,195,15);
    PL(Screen,0,196,319,196,15);
    for(int i=0;i<18;i++) str+=c8[i];
    DS16(Screen,85,203,str,12);
    str= "";
    DS16(Screen,50,222,"Developed by C.H. Dep of EEA",2);
    SXY(Screen,0,0);
    ExecuteInstruction(Screen);
    wait(0.2);
}

void DS16(Serial *Screen, int x, int y, string str, int color)
{
    string temp = "DS16("+int2string(x)+","+int2string(y)+",'"+str+"',"+int2string(color)+");";
    Screen->printf(temp.c_str());
}

void DS24(Serial *Screen, int x, int y, string str, int color)
{
    string temp = "DS24("+int2string(x)+","+int2string(y)+",'"+str+"',"+int2string(color)+");";
    Screen->printf(temp.c_str());
}

void SXY(Serial *Screen, int x, int y)
{
    string temp = "SXY("+int2string(x)+","+int2string(y)+");";
    Screen->printf(temp.c_str());
}

void CLS(Serial *Screen, int color)
{
    string temp = "CLS("+int2string(color)+");";
    Screen->printf(temp.c_str());
}

void PL(Serial *Screen, int x1, int y1, int x2, int y2, int color)
{
    string temp = "PL("+int2string(x1)+","+int2string(y1)+","+int2string(x2)+","+int2string(y2)+","+int2string(color)+");";
    Screen->printf(temp.c_str());
}

void PS(Serial *Screen, int x1, int y1, int color)
{
    string temp = "PS("+int2string(x1)+","+int2string(y1)+","+int2string(color)+");";
    Screen->printf(temp.c_str());
}

void ExecuteInstruction(Serial *Screen)
{
    Screen->printf("\r\n");
}

string int2string(int x)
{
    stringstream ss;
    ss << x;
    string str = ss.str();
    return str;
}

string float2string(float x)
{
    int xx = x * 100;
    float xxx = (float)xx / 100;
    stringstream ss;
    ss << xxx;
    string str = ss.str() + ' ';
    return str;
}

 
