/*
 *  Nrf2401A.h
 *  A simplistic interface for using Sparkfun's Nrf2401A breakout boards with Arduino
 *
 *  Ported to mbed by Jas Strong <jasmine@heroicrobotics.com>
 *
 *  Original code for http://labs.ideo.com by Jesse Tane March 2009
 *
 *  License:
 *  --------
 *  This is free software. You can redistribute it and/or modify it under
 *  the terms of Creative Commons Attribution 3.0 United States License. 
 *  To view a copy of this license, visit http://creativecommons.org/licenses/by/3.0/us/ 
 *  or send a letter to Creative Commons, 171 Second Street, Suite 300, San Francisco, California, 94105, USA.
 *
 *  Original version Notes:
 *  -----------------------
 *  For documentation on how to use this library, please visit http://www.arduino.cc/playground/Main/InterfacingWithHardware
 *  Pin connections should be as follows for Arduino:
 *
 *  DR1 = 2  (digital pin 2)
 *  CE  = 3
 *  CS  = 4
 *  CLK = 5
 *  DAT = 6
 *
 */

#include "mbed.h"

#define NRF2401_BUFFER_SIZE 25

class Nrf2401
{
  public:
  
  // properties
  
  volatile unsigned char data[NRF2401_BUFFER_SIZE];
  volatile unsigned int remoteAddress;
  volatile unsigned int localAddress;
  volatile unsigned char dataRate;
  volatile unsigned char channel;
  volatile unsigned char power;
  volatile unsigned char mode;
  
  // methods
  
  Nrf2401(PinName n_DR1, PinName n_CE, PinName n_CS, PinName n_CLK, PinName n_DAT);
  void rxMode(unsigned char messageSize=0);
  void txMode(unsigned char messageSize=0);
  void write(unsigned char dataByte);
  void write(unsigned char* dataBuffer=0);
  void read(unsigned char* dataBuffer=0);
  bool available(void);

  // you shouldn't need to use anything below this point..
private: 
  volatile unsigned char payloadSize;
  volatile unsigned char configuration[15];
  void configure(void);
  void loadConfiguration(bool modeSwitchOnly=false);
  void loadByte(unsigned char byte);
  inline void select_chip(void) {
    _cs = 1;
  }

  inline void deselect_chip(void) {
    _cs = 0;
  }

  inline void enable_chip(void) {
    _ce = 1;
  }

  inline void disable_chip(void) {
    _ce = 0;
  }

  inline void cycle_clock(void) {
    _clk = 1;
    wait_us(1);
    _clk = 0;
  }

  inline void tx_data_lo(void) {
    _dat.output();
    _dat = 1;
  }

  inline void tx_data_hi(void) {
    _dat.output();
    _dat = 1;
  }

  inline int rx_data_hi(void) {
    _dat.input();
    return _dat;
  }

  inline int data_ready(void) {
    return _dr1;
  }
  
  DigitalOut   _ce, _cs, _clk;
  DigitalIn    _dr1;
  DigitalInOut _dat;
};
