/***************************************************************************/
// DMA-enabled high data rate driver for Heroic Robotics FastPixel strips.
// Written by Jas Strong <jasmine@heroicrobotics.com>
// Copyright (c) 2013-2014 Heroic Robotics, Inc.
//
// FastPixel is a family of high performance LED strips available from
// Heroic Robotics, Inc.  http://heroicrobotics.com/ - check them out!
//
// These strips are capable of supporting 18 Mbit/sec when run on PixelPusher
// hardware;  your performance on mbed is likely to be somewhat lower due to
// the lack of high performance driver chips on the SPI lines.
//
// Heroic Robotics also sells a family of dedicated LED controllers called
// PixelPusher-  almost certainly the best LED controller in the world.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
//
// Some portions originally from:
//
// Mbed library to control LPD8806-based RGB LED Strips
// (c) 2011 Jelmer Tiete
// This library is ported from the Arduino implementation of Adafruit Industries
// found at: http://github.com/adafruit/LPD8806
// and their strips: http://www.adafruit.com/products/306
// Released under the MIT License: http://mbed.org/license/mit
//
// Parameterized and modified to use soft SPI.
// Jas Strong <jasmine@electronpusher.org>
// Then remonstered to use hardware SPI for blast mode.
/*****************************************************************************/
 
// Heavily modified by Jas Strong, 2012-10-04
// Changed to use a virtual base class and to use software SPI.

#include "mbed.h"
#include "LedStrip.h"
#include "MODDMA.h"

#ifndef MBED_FastPixelLPD8806_H
#define MBED_FastPixelLPD8806_H

class FastPixelLPD8806 : public LedStrip {

 public:

  FastPixelLPD8806(PinName dataPin, PinName clockPin, int n);
  virtual void begin(void);
  virtual void show(void);
  virtual void blank(void);
  virtual void setPixelColor(uint16_t n, uint8_t r, uint8_t g, uint8_t b);
  virtual void setPackedPixels(uint8_t * buffer, uint32_t n);
  virtual void setPixelB(uint16_t n, uint8_t b);
  virtual void setPixelG(uint16_t n, uint8_t g);
  virtual void setPixelR(uint16_t n, uint8_t r);
  virtual void setPixelColor(uint16_t n, uint32_t c);
  virtual uint16_t numPixels(void);
  virtual uint32_t Color(uint8_t, uint8_t, uint8_t);
  virtual uint32_t total_luminance(void);
  
 private:
  SPI _spi;
  void write(uint8_t byte);
  uint8_t *pixels;     // Holds LED color values
  uint16_t numLEDs;     // Number of RGB LEDs in strand
  MODDMA_Config * dma_config;
  int strip_num;
  

  uint32_t clock_mask;
  uint32_t data_mask;
    
};
#endif