#include "mbed.h"
#include "MODDMA.h"

#include "FastPixelLPD8806.h"


MODDMA dma;
int current_strip_fill;

LedStrip *strips[2];

DigitalOut myled(LED1);

int main() {
    
    // First, create the strip objects.
    // The global current_strip_fill variable is an unfortunate workaround for the
    // fact that we virtualize these strips but the DMA engine needs to know which
    // one just got filled.
    
    current_strip_fill = 0;
    strips[0] = new FastPixelLPD8806(p5, p7, 240);
    current_strip_fill = 1;
    strips[1] = new FastPixelLPD8806(p11, p13, 240);
    
    int j=0;
    
    while (1) {
        // then write something into the strips:
        for (int i=0; i<240; i++) {
            strips[0]->setPixelColor(i, (j++) % 256, (j++) % 256, (j++) % 256);
            strips[1]->setPixelColor(i, (j++) % 256, (j++) % 256, (j++) % 256);
        }
        // then show the strips:
        current_strip_fill = 0;
        strips[0]->show();
        
        current_strip_fill = 1;
        strips[1]->show();
    }  
}
