#ifndef HARDWAREPULSECOUNTER_H
#define HARDWAREPULSECOUNTER_H
 
#include "mbed.h"
#include <string>

using namespace std;
 
class PulseCounter
{
    public:
        PulseCounter(TIM_TypeDef *TIMx, GPIO_TypeDef *GPIOx, uint16_t PINx);
        void GpioConfig();
        void CounterConfig();
        void SlaveConfig();
        void MasterConfig();
        void sConfig();
        void TIM_Start();
        void Start_Configurations();
        uint32_t getTimerValue();
        void clearTimerValue();
    private:
        TIM_HandleTypeDef htim;
        GPIO_InitTypeDef GPIO_InitStruct;
        TIM_SlaveConfigTypeDef sSlaveConfig;
        TIM_MasterConfigTypeDef sMasterConfig;
        TIM_IC_InitTypeDef sConfigIC;
        uint32_t count;
        TIM_TypeDef *TIM;
        GPIO_TypeDef *GPIO;
        uint16_t PIN;
};
#endif