#include "HardwarePulseCounter.h"

PulseCounter::PulseCounter(TIM_TypeDef *TIMx, GPIO_TypeDef *GPIOx, uint16_t PINx){
    this->TIM = TIMx;
    this->GPIO = GPIOx;
    this->PIN = PINx;
};


void PulseCounter::CounterConfig(){
    
    if(this->TIM == TIM1){
        __HAL_RCC_TIM1_CLK_ENABLE();
    }
    
    else if(this->TIM == TIM2){
        __HAL_RCC_TIM2_CLK_ENABLE();
    }
    
    else if(this->TIM == TIM3){
        __HAL_RCC_TIM3_CLK_ENABLE();
    }
    
    else if(this->TIM == TIM4){
        __HAL_RCC_TIM4_CLK_ENABLE();
    }
    
    this->htim.Instance = this->TIM;
    this->htim.Init.Period = 0xffff;
    this->htim.Init.Prescaler = 1;
    this->htim.Init.ClockDivision = TIM_CLOCKDIVISION_DIV1;
    this->htim.Init.CounterMode = TIM_COUNTERMODE_UP;
    this->htim.Init.AutoReloadPreload = TIM_AUTORELOAD_PRELOAD_DISABLE;
}


void PulseCounter::GpioConfig(void){
    
    if(this->GPIO == GPIOA){
        __HAL_RCC_GPIOA_CLK_ENABLE();
    }
    
    else if(this->GPIO == GPIOB){
        __HAL_RCC_GPIOB_CLK_ENABLE();
    }
    
    else if(this->GPIO == GPIOC){
        __HAL_RCC_GPIOC_CLK_ENABLE();
    }
    
    else if(this->GPIO == GPIOD){
        __HAL_RCC_GPIOD_CLK_ENABLE();
    }
    
    
    this->GPIO_InitStruct.Pin = this->PIN;
    this->GPIO_InitStruct.Mode = GPIO_MODE_IT_RISING;;
    this->GPIO_InitStruct.Pull = GPIO_NOPULL;
    this->GPIO_InitStruct.Speed = GPIO_SPEED_FREQ_LOW;
    HAL_GPIO_Init(this->GPIO, &this->GPIO_InitStruct);
}


void PulseCounter::SlaveConfig(){
    
    this->sSlaveConfig.SlaveMode = TIM_SLAVEMODE_EXTERNAL1;
    this->sSlaveConfig.InputTrigger = TIM_TS_TI1FP1;
    this->sSlaveConfig.TriggerPolarity = TIM_TRIGGERPOLARITY_RISING;
    this->sSlaveConfig.TriggerFilter = 15;
    HAL_TIM_SlaveConfigSynchronization(&this->htim, &this->sSlaveConfig);
}


void PulseCounter::MasterConfig(){
    
    this->sMasterConfig.MasterOutputTrigger = TIM_TRGO_UPDATE;
    this->sMasterConfig.MasterSlaveMode = TIM_MASTERSLAVEMODE_DISABLE;
    HAL_TIMEx_MasterConfigSynchronization(&this->htim, &this->sMasterConfig);
}


void PulseCounter::sConfig(){
    
    this->sConfigIC.ICPolarity = TIM_INPUTCHANNELPOLARITY_RISING;
    this->sConfigIC.ICSelection = TIM_ICSELECTION_DIRECTTI;
    this->sConfigIC.ICPrescaler = TIM_ICPSC_DIV1;
    this->sConfigIC.ICFilter = 0;
}


void PulseCounter::TIM_Start(){
  
  if(this->TIM == TIM2){
    RCC->APB1ENR |= RCC_APB1ENR_TIM2EN;
  }
  
  else if(this->TIM == TIM3){
    RCC->APB1ENR |= RCC_APB1ENR_TIM3EN;
  }
  
  else if(this->TIM == TIM4){
    RCC->APB1ENR |= RCC_APB1ENR_TIM4EN;
  }
  
  this->TIM->CR1 |= TIM_CR1_CEN;
}

void PulseCounter::Start_Configurations(){
    
    this->GpioConfig();
    this->CounterConfig();
    this->SlaveConfig();
    this->MasterConfig();
    this->sConfig();
    this->TIM_Start();
    
    HAL_TIM_Base_Start(&this->htim);
}

uint32_t PulseCounter::getTimerValue(){
    
    this->count = this->TIM->CNT;
    return this->count;
}

void PulseCounter::clearTimerValue(){
    
    this->TIM->CNT = 0;  
}