#include "mbed.h"
#include "SerialBuffered.h"

#ifndef HEPTA_SERIAL_H
#define HEPTA_SERIAL_H

class HeptaSerial {
public:

    enum JpegResolution {
         JpegResolution80x64 = 0x01,   // unofficial
         JpegResolution160x128 = 0x03, // unofficial
         JpegResolution320x240 = 0x05, // QVGA
         JpegResolution640x480 = 0x07  // VGA
    };

    enum ErrorNumber {
        NoError = 0x00,
        UnexpectedReply = 0x04,
        ParameterError = 0x0b,
        SendRegisterTimeout = 0x0c,
        CommandIdError = 0x0d,
        CommandHeaderError = 0xf0,
        SetTransferPackageSizeWrong = 0x11
    };

    enum Baud {
        Baud460800 = 0x02,
        Baud230400 = 0x03,
        Baud115200 = 0x04,
        Baud57600  = 0x05,
        Baud28800  = 0x06,
        Baud14400  = 0x07  // Default. 
    };

    enum ResetType {
        Nomal = 0x00,
        High  = 0xff
    };

    HeptaSerial(PinName tx, PinName rx, int baud = 14400);

    ~HeptaSerial();

    ErrorNumber sync();
    ErrorNumber init(Baud baud, JpegResolution jr);
    ErrorNumber getJpegSnapshotPicture();
    ErrorNumber getJpegSnapshotPicture_data();
    void setmbedBaud(Baud baud);
    void Sync(void);
    void initialize(Baud baud,JpegResolution jr);
    void test_jpeg_snapshot_picture(int CAPTURE_FRAMES);
    void test_jpeg_snapshot_data(int CAPTURE_FRAMES);
    void jpeg_callback(char *buf, size_t siz);
    
    
    
    
private:
    SerialBuffered serial;
    static const int COMMAND_LENGTH = 6;
    static const int SYNCMAX = 60;
    static const int packageSize = 256;
    //static const int CAPTURE_FRAMES = 3;
    
    ErrorNumber sendInitial(Baud band, JpegResolution jr);
    ErrorNumber sendGetPicture(void);
    ErrorNumber sendSnapshot(void);    
    ErrorNumber sendSetPackageSize(uint16_t packageSize);
    ErrorNumber sendReset(ResetType specialReset);  
    ErrorNumber recvData(uint32_t *length);
    ErrorNumber sendSync();
    ErrorNumber recvSync();
    ErrorNumber sendAck(uint8_t commandId, uint16_t packageId);
    ErrorNumber recvAckOrNck();

    bool sendBytes(char *buf, size_t len, int timeout_us = 20000);
    bool recvBytes(char *buf, size_t len, int timeout_us = 20000);
    bool waitRecv();
    bool waitIdle();
};

#endif
