/*
*************************************************************
H29/07_20/T.Umezawa
1:SD.....OK!
2:MPU9250(Accel) = OK
3:MPU9250(Gyro) = OK
4:MPU9250(Mag_compass) = 微妙
5:GPS sensing Mode = (サンプリング時間の修正)
6:CAM Mode = OK!(微妙だった)
7:Temperature sensing = OK!
8:Xbee mode = OK!
*************************************************************
*/
#include "mbed.h"
#include "SDHCFileSystem.h"
#include "HeptaXbee.h"
#include "HeptaSerial.h"
#include "Hepta9axis.h"
#include "HeptaTemp.h"
#include "HeptaBattery.h"
#define USE_JPEG_HIGH_RESOLUTION  1

Serial pc(USBTX,USBRX);
SDFileSystem sd(p5, p6, p7, p8, "fs");
HeptaXbee xbee(p9,p10);
HeptaSerial camera(p13, p14);
HeptaMPU9250 MPU9250(p28,p27,0xD0,0x18);//sda,scl,acc&gyro_address,mag_gyro
HeptaTemp heptatemp(p17);
HeptaBattery bat(p16,p26);
DigitalOut CAM_SW(p25);//CAM_control
DigitalOut GPS_SW(p24);//GPS_control

int main()
{
    char mode;
    pc.baud(9600);

    while(1) {

        /*
        ************
        Mode select
        ***********
        */
        pc.printf("\r\n");
        pc.printf("*********************************\r\n");
        pc.printf("Hello world.\r\n");
        pc.printf("My name is HEPTA2\r\n");
        pc.printf("Please select mode.\r\n");
        pc.printf("a:SD test Mode\r\n");
        pc.printf("b:Check Battery Level\r\n");
        pc.printf("c:Gyro Sening Mode\r\n");
        pc.printf("d:Accel Sensing Mode\r\n");
        pc.printf("e:Magnet Sensig Mode\r\n");
        pc.printf("f:GPS Test Sensing Mode\r\n");
        pc.printf("g:CAM Mode\r\n");
        pc.printf("h:Temperature Sensing Mode\r\n");
        pc.printf("i:Xbee Mode\r\n");
        pc.printf("j:Xbee & Temperature Mode\r\n");//恒温槽用
        pc.printf("k:All Transmitting Mode\r\n");
        pc.printf("l:Test Mode\r\n");
        pc.printf("m:Test Mode\r\n");
        pc.printf("*********************************\r\n");

        mode = pc.getc();
        pc.printf("\r\n");
        pc.printf("Your select Mode = %c\r\n",mode);
        wait(0.5);

        switch(mode) {
            case'a': {

                printf("=============\r\n");
                printf("SD test Mode\r\n");
                printf("=============\r\n");
                FILE *fp = fopen("/fs/myfile.txt", "w");
                if(fp == NULL) {
                    pc.printf("Could not open file for write\r\n");
                } else {
                    fprintf(fp, "\n\rHello World!\n\r");
                    printf("SD Check Complete!!\r\n");
                    fclose(fp);
                }


                break;
            }//case'1'

            /*
            ************************
            Check Battery Level mode
            ************************
            */
            case'b': {
                float bt;
                bat.vol(&bt);
                pc.printf("V = %f\r\n",bt);
                break;
            }

            /*
            ******************
            Gyro sensing mode
            ******************
            */

            case'c': {
                printf("===================\r\n");
                printf("Gyro sensing Mode\r\n");
                printf("===================\r\n");
                float gx,gy,gz;
                for(int i = 0; i < 10; i++) {
                    MPU9250.sen_gyro(&gx,&gy,&gz);
                    pc.printf("GX = %f,GY = %f,GZ = %f\r\n",gx,gy,gz);
                    wait(0.5);
                }
                break;
            }//case'2'

            /*
            ******************
            Accel sensing mode
            ******************
            */

            case'd': {
                printf("===================\r\n");
                printf("Accel sensing Mode\r\n");
                printf("===================\r\n");
                float ax,ay,az;
                for(int i = 0; i < 10; i++) {
                    MPU9250.sen_acc(&ax,&ay,&az);
                    pc.printf("AX = %f,AY = %f,AZ = %f\r\n",ax,ay,az);
                    wait(0.5);
                }
                break;
            }//case'3'

            /*
            ******************
            Magnet sensing mode
            ******************
            */

            case'e': {
                float mx,my,mz;
                printf("===================\r\n");
                printf("Magnet sensing Mode\r\n");
                printf("===================\r\n");
                for(int i = 0; i < 10; i++) {
                    MPU9250.sen_mag(&mx,&my,&mz);
                    pc.printf("MX = %f,MY = %f,MZ = %f\r\n",mx,my,mz);
                    wait(0.5);
                }
                break;
            }//case'4'

            /*
            ******************
            GPS sensing mode
            ******************
            */

            case'f': {

                printf("===================\r\n");
                printf("GPS sensing Mode\r\n");
                printf("===================\r\n");
                while(1) pc.putc(camera.getc());
                break;
            }//case'4'

            /*
            ******************
            Cam Snapshot mode
            ******************
            */

            case'g': {
                GPS_SW = 0;
                CAM_SW = 1;
                printf("\r\n");
                printf("==========\r\n");
                printf("CameraC1098\r\n");
                printf("==========\r\n");
                camera.Sync();
                camera.initialize(HeptaSerial::Baud115200, HeptaSerial::JpegResolution320x240);
                camera.test_jpeg_snapshot_picture(1);

                break;
            }//case'6'

            /*
            ******************
            Temp sensing mode
            ******************
            */

            case'h': {
                printf("==================\r\n");
                printf("Temp sensing Mode\r\n");
                printf("==================\r\n");
                float temp;
                for(int i = 0; i<100; i++) {
                    heptatemp.temp_sense(&temp);
                    pc.printf("%f\r\n",temp);
                    //xbee.printf("%f\r\n",temp);
                }
                break;
            }//case'7'

            /*
            ***********
            Xbee mode
            ***********
            */

            case'i': {

                int i=0,rcmd=0,cmdflag=0;
                xbee.printf("Count Up!\r");
                while(1) {
                    xbee.printf("num = %d\r",i);
                    i++;
                    wait(1.0);
                    xbee.xbee_recieve(&rcmd,&cmdflag);
                    pc.printf("rcmd=%d, cmdflag=%d\r\n",rcmd, cmdflag);
                    if (cmdflag == 1) {
                        if (rcmd == 'a') {
                            pc.printf("Command Get %d\r\n",rcmd);
                            xbee.printf("HEPTA Uplink OK\r");
                        }
                        xbee.initialize();
                    }
                }

                break;
            }//case'8'

            /*
            ******************
            Temp sensing mode by Xbbe
            ******************
            */

            case'j': {

                printf("==================\r\n");
                printf("Temp sensing Mode & Xbee\r\n");
                printf("==================\r\n");

                float temp;
                while(1) {
                    FILE *fp = fopen("/fs/myfile.csv", "a");
                    heptatemp.temp_sense(&temp);
                    pc.printf("%f\r\n",temp);
                    xbee.printf("%f\r\n",temp);
                    fprintf(fp, "%f\n",temp);
                    fclose(fp);
                }
                break;
            }//case'9'

            /*
            *********************
            All Transmitting Mode
            *********************
            */

            case'k': {

                printf("==================\r\n");
                printf("All Transmitting Mode\r\n");
                printf("==================\r\n");
                char gx[4],gy[4],gz[4],ax[4],ay[4],az[4],mx[4],my[4],mz[4],lad[8],log[8],bt[4],temp[4];
                char ddata[60];
                int dsize[6];
                while(1) {
                    
                     MPU9250.sen_gyro_u16(gx,gy,gz,&dsize[0]);
                     MPU9250.sen_acc_u16(ax,ay,az,&dsize[1]);
                     MPU9250.sen_mag_u16(mx,my,mz,&dsize[2]);
                     camera.lat_log_sensing_u16(lad,log,&dsize[3]);
                     bat.vol_u16(bt,&dsize[4]);
                     heptatemp.temp_sense_u16(temp,&dsize[5]);
                    xbee.xbee_transmit(ddata,60,gx,gy,gz,ax,ay,az,mx,my,mz,lad,log,bt,temp,dsize[0],dsize[0],dsize[0],dsize[1],dsize[1],dsize[1],dsize[2],dsize[2],dsize[2],dsize[3],dsize[3],dsize[4],dsize[5],13);
                }
                break;
            }//case'9'
            /*
                       ******************
                       Cam Snapshot mode
                       ******************
                       */

            case'l': {
                GPS_SW = 0;
                CAM_SW = 1;
                printf("\r\n");
                printf("==========\r\n");
                printf("CameraC1098\r\n");
                printf("==========\r\n");
                camera.Sync();
                camera.initialize(HeptaSerial::Baud115200, HeptaSerial::JpegResolution320x240);
                camera.test_jpeg_snapshot_data(1);

                break;
            }//case'6'

            case'm': {
                pc.printf("L:GPS GPGGA Mode\r\n");
                int quality=0,stnum=0,gps_check=0;
                char ns='A',ew='B',aunit='m';
                float time=0.0,latitude=0.0,longitude=0.0,hacu=0.0,altitude=0.0;
                for(int i=1; i<10; i++) {
                    camera.gga_sensing(&time, &latitude, &ns, &longitude, &ew, &quality, &stnum, &hacu, &altitude, &aunit, &gps_check);
                    if((gps_check==0)|(gps_check==1)) {
                        pc.printf("GPGGA,%f,%f,%c,%f,%c,%d,%d,%f,%f,%c\r\n",time,latitude,ns,longitude,ew,quality,stnum,hacu,altitude,aunit);
                    }
                }
                break;
            }

            default:
                break;


        }
    }
}