#include "mbed.h"
#include "pt.h"
#include <vector>

#define ADC_THRESH_HI  0.2
#define ADC_THRESH_LO  0.1
#define VDD 3.3

Serial      pc(USBTX, USBRX);   // tx, rx


DigitalOut  T0_gnd(p15);        // for ground
DigitalIn   T0_chg(p16);        // charge pull-up
AnalogIn    T0(p17);

DigitalOut  T1_gnd(p18);        // for ground
DigitalIn   T1_chg(p19);        // charge pull-up
AnalogIn    T1(p20);

static vector<int>  triggerString, newString;

static PT_THREAD(setTrigger_thread(struct pt *pt)) {

    static char readChar;

    PT_BEGIN(pt);

    while (1) {
        PT_WAIT_UNTIL(pt, (pc.readable() == 1) );

        readChar = pc.getc();

        if ( (readChar == 'S') || (readChar == 's') ) {
            newString.clear();
        }
        else if( readChar == '0' ) {
            newString.push_back(0);
        }
        else if ( readChar == '1') {
            newString.push_back(1);
        }
        else if( (readChar == 'e') || (readChar == 'E') )
            triggerString.swap(newString);
        }
    }

    PT_END(pt);

} /* static PT_THREAD(setTrigger_thread()) */

static struct pt setTrigger_pt;

int main() {

    int             userInput;

    int             n;

    float           T0_voltage, T1_voltage;
    float           T0_bufVoltage, T1_bufVoltage;

    int             T0_touched, T1_touched;

    PT_INIT(&setTrigger_pt);


    T0_gnd = 0;
    T1_gnd = 0;

    T0_voltage = VDD;
    T1_voltage = VDD;

    T0_touched = 0;
    T1_touched = 0;

    userInput = -1;

    n = 0;
    triggerLength = 0;

    T0_chg.mode(PullUp);
    T1_chg.mode(PullUp);

    T0_chg.mode(PullNone);
    T1_chg.mode(PullNone);

    while (1) {

        // pc.printf("Enter a binary sequence ('S' to start, 'E' to end): ");

        PT_SCHEDULE(setTrigger_thread(&setTrigger_pt))

        T0_chg.mode(PullUp);
        T1_chg.mode(PullUp);

        T0_chg.mode(PullNone);
        T1_chg.mode(PullNone);

        T0_bufVoltage = 0.0;
        T1_bufVoltage = 0.0;

        T0_touched = 0;
        T1_touched = 0;

        for (int i = 0; i < 5; i++) {
            T0_voltage = T0.read();
            T1_voltage = T1.read();

//            pc.printf("%d: 0=%f, 1=%f\n", i, T0_voltage, T1_voltage);

            T0_bufVoltage += T0_voltage;
            T1_bufVoltage += T1_voltage;
            wait_ms(1);
        }

//        pc.printf("0=%f, 1=%f\n", T0_bufVoltage, T1_bufVoltage);

        if (T0_bufVoltage < 1.0) {
            T0_touched = 1;
        }

        if (T1_bufVoltage < 1.0) {
            T1_touched = 1;
        }

        if ( (T0_touched == 1) && (T1_touched == 1) ) {
            pc.printf("TOUCH ERROR\n");
            n = 0;

            continue;
        }
        else if (T0_touched == 1) {
            pc.printf("T0 touched\n");
            userInput = 0;
        }
        else if (T1_touched == 1) {
            pc.printf("T1 touched\n");
            userInput = 1;
        }

        if ( (T1_touched == 1) || (T0_touched == 1) ) {
            if ( (triggerLength != 0) && (userInput == triggerString[n]) ) {
                n = n + 1;

                if (n == triggerLength) {
                    pc.printf("MATCH\n");
                    n = 0;
                }
            } else {
                n = 0;
            }

            do {
                T0_voltage = VDD * T0.read();
                T1_voltage = VDD * T1.read();
//                pc.printf("%f, %f\n", T0_voltage, T1_voltage);
                wait_ms(5);
            } while ( (T0_voltage < ADC_THRESH_HI) || (T1_voltage < ADC_THRESH_HI) );
        }

    } /* while (1) */

} /* int main () */
