#include "mbed.h"
#include <vector>

#define ADC_THRESH_HI  0.2
#define ADC_THRESH_LO  0.1
#define VDD 3.3

Serial      pc(USBTX, USBRX);   // tx, rx


DigitalOut  T0_gnd(p15);        // for ground
DigitalIn   T0_chg(p16);        // charge pull-up
AnalogIn    T0(p17);

DigitalOut  T1_gnd(p18);        // for ground
DigitalIn   T1_chg(p19);        // charge pull-up
AnalogIn    T1(p20);

void readTrigger(vector<int> *);

int main() {

    int             userInput;

    int             n;
    int             triggerLength;

    float           T0_voltage, T1_voltage;
    float           T0_bufVoltage, T1_bufVoltage;

    int             T0_touched, T1_touched;

    vector<int>     triggerString;

    T0_gnd = 0;
    T1_gnd = 0;

    T0_voltage = VDD;
    T1_voltage = VDD;

    T0_touched = 0;
    T1_touched = 0;

    userInput = -1;

    n = 0;
    triggerLength = 0;

    T0_chg.mode(PullUp);
    T1_chg.mode(PullUp);

    T0_chg.mode(PullNone);
    T1_chg.mode(PullNone);

    while (1) {

        if (pc.readable() == 1) {
            readTrigger(&triggerString);
            triggerLength = triggerString.size();
            n = 0;
        }

        T0_chg.mode(PullUp);
        T1_chg.mode(PullUp);

        T0_chg.mode(PullNone);
        T1_chg.mode(PullNone);

        T0_bufVoltage = 0.0;
        T1_bufVoltage = 0.0;

        T0_touched = 0;
        T1_touched = 0;

        for (int i = 0; i < 5; i++) {
            T0_voltage = T0.read();
            T1_voltage = T1.read();

//            pc.printf("%d: 0=%f, 1=%f\n", i, T0_voltage, T1_voltage);

            T0_bufVoltage += T0_voltage;
            T1_bufVoltage += T1_voltage;
            wait_ms(1);
        }

//        pc.printf("0=%f, 1=%f\n", T0_bufVoltage, T1_bufVoltage);

        if (T0_bufVoltage < 1.0) {
            T0_touched = 1;
        }

        if (T1_bufVoltage < 1.0) {
            T1_touched = 1;
        }

        if ( (T0_touched == 1) && (T1_touched == 1) ) {
            pc.printf("TOUCH ERROR\n");
            n = 0;

            continue;
        }
        else if (T0_touched == 1) {
            pc.printf("T0 touched\n");
            userInput = 0;
        }
        else if (T1_touched == 1) {
            pc.printf("T1 touched\n");
            userInput = 1;
        }

        if ( (T1_touched == 1) || (T0_touched == 1) ) {
            if ( (triggerLength != 0) && (userInput == triggerString[n]) ) {
                n = n + 1;

                if (n == triggerLength) {
                    pc.printf("MATCH\n");
                    n = 0;
                }
            } else {
                n = 0;
            }

            do {
                T0_voltage = VDD * T0.read();
                T1_voltage = VDD * T1.read();
//                pc.printf("%f, %f\n", T0_voltage, T1_voltage);
                wait_ms(5);
            } while ( (T0_voltage < ADC_THRESH_HI) || (T1_voltage < ADC_THRESH_HI) );
        }

    }

} /* int main() */

void readTrigger(vector<int> *currentString) {

    char            readChar;

    readChar = pc.getc();

    if ( (readChar == 's') || (readChar == 'S') ) {
        pc.printf("Starting new sequence.\n");

         while (1) {
            if ( pc.readable() == 1 ) {

                readChar = pc.getc();

                if ( (readChar == 'e') || (readChar == 'E') ) {

                    pc.printf("\nGot new sequence.\n");

                    for (int i = 0; i < currentString->size(); i++) {
                        pc.printf("%d", currentString[i]);
                    }
                    pc.printf("\n");

                    return;
                }
                else if ( readChar == '0' ) {
                    pc.putc('0');
                    currentString->push_back(0);
                }
                else if ( readChar == '1') {
                    pc.putc('1');
                    currentString->push_back(1);
                }
            }
        }
    }
    else {
        return;
    }

} /* void> readTrigger(vector<int> *currentString) */
