#include "touchmachine.h"
#include "mbed.h"
#include "com.h"
TouchButton touch0(p20,p19,p18, THRESHOLD, TIMER_THRESHOLD,"0");
TouchButton touch1(p17,p16,p15, THRESHOLD, TIMER_THRESHOLD,"1");
Handler handler("Serial");

void runser() {
    handler.run();
}

TouchMachine::TouchMachine(char *c) {
#ifdef DEBUGTM
    com.printf("INIT TM\r\n");
#endif    
    touchState=WAITING;
    t0 = &touch0;
    t1 = &touch1;
    hand = &handler;
    com.attach(runser);
    
};

void TouchMachine::check() {
#ifdef DEBUGTM
    com.printf("CHECK BUTTONS\r\n");
#endif    
    t0state = t0->checkState();
    t1state = t1->checkState();
    if (t0state && t1state) {
    #ifdef DEBUGTM1
        com.printf("ERR-CHK\r\n");
    #endif
        touchState=ERROR;
    }else if (t0state) {
    #ifdef DEBUGTM1
        com.printf("ZERO-CHK\r\n");
    #endif
        touchState=ZERO;
    } else if(t1state) {
    #ifdef DEBUGTM1
        com.printf("ONE-CHK\r\n");
    #endif    
        touchState=ONE;
    } else {
    #ifdef DEBUGTM
        com.printf("WAIT-CHK\r\n");
    #endif    
        touchState=WAITING;
    }
}

bool TouchMachine::isMatch() {
    if (touchState==MATCH) {
#ifdef DEBUGTM1
        com.printf("MATCH-TM\r\n");
#endif    
        return true;
    }
    return false;
}

bool TouchMachine::isOne() {
    if (touchState==ONE) {
#ifdef DEBUGTM
        com.printf("ONE-TM\r\n");
#endif    
        return true;
    }
    return false;
}


bool TouchMachine::isZero() {
    if (touchState==ZERO) {
#ifdef DEBUGTM
        com.printf("ZERO-TM\r\n");
#endif    
        return true;
    }
    return false;
}

bool TouchMachine::isWaiting() {
    if (touchState==WAITING) {
#ifdef DEBUGTM
        com.printf("WAITING-TM\r\n");
#endif    
        return true;
    }
    return false;
}

bool TouchMachine::isError() {
    if (touchState==ERROR) {
#ifdef DEBUGTM
        com.printf("ERROR-TM\r\n");
#endif    
        return true;
    }
    return false;
}

void TouchMachine::setError() {
    touchState=ERROR;
}

void TouchMachine::setMatch() {
    touchState=MATCH;
}

void TouchMachine::resetTouch() {
#ifdef DEBUGTM1
    com.printf("RESET FOR TOUCH\r\n");
#endif    
    touchState=WAITING;
    loadMatchStr();
}

char TouchMachine::getMatchChar(){
    if(*pmatchstr!=NULL){
    return *pmatchstr++;
    }
      return NULL;
}

char TouchMachine::nextMatchChar(){
    return *(pmatchstr);
}

void TouchMachine::loadMatchStr(){
    pmatchstr=hand->getMatchString();
#ifdef DEBUGTM1
    com.printf("LOAD MATCH STR-%s\r\n",pmatchstr);
#endif
}

void TouchMachine::touchError() {
    com.printf("TOUCH ERROR\r\n");
}

void TouchMachine::touchMatch() {
    com.printf("***MATCH***\r\n");
}

void TouchMachine::run() {    
    while(1) {
        if (hand->isReady()) {
            resetTouch();
            loadMatchStr();
            checkTouchForMatch();
        }    
     }
}

void TouchMachine::checkTouchForMatch() {
    char c;
    while(( isWaiting() || isOne() || isZero())&& hand->isReady()) {
            check();
            if(isOne() || isZero()) {
                
                c = getMatchChar();
                #ifdef DEBUGTM1
                    com.printf("CHR TO MATCH %c\r\n",c);
                #endif
                switch(c) {
                case NULL:
                    setMatch();
                    break;                    
                case ZEROCHR:
                    if(!isZero()) 
                        setError();
                     
                    break;
                case ONECHR:
                    if(!isOne()) 
                        setError();
                    
                default:
                    break;
                    
               
                }
            }
            
            
            if(isError()) {
                touchError();
                resetTouch();
            }
            checkMatch();
            if(isMatch()) {
                touchMatch();
                resetTouch();
            }
            waitForRelease();

    }
}

void TouchMachine::waitForRelease() {
    while(!isWaiting() && hand->isReady()) {
        check();
    }
}

void TouchMachine::checkMatch() {
 if(!isError() && nextMatchChar()==NULL) {
               setMatch();
  }
 }