#include "mbed.h"
#include "touchbutton.h"
#include "com.h"

#ifdef DEBUGTOUCHLED
DigitalOut debugled(LED1);
#endif

float TouchButton::difference() {
    return previousValue - currentValue;
}

TouchButton::TouchButton(PinName ain, PinName din, PinName dout, float threshold, int debounceTime, char *nm) :   sensor(ain), charger(din), ground(dout) {

    setThreshold(threshold);
    setDebounceTime(debounceTime);
    AnalogIn sensor(ain);
    DigitalIn charger(din);
    DigitalOut ground(dout);
    ground.write(0);
    timer.start();
    sample();
    storeValue();
    strcpy(name,nm);
#ifdef DEBUGTOUCH
        com.printf("INIT BUTTON %s\r\n",name);
#endif
}

void TouchButton::storeValue() {
    previousValue=currentValue;
}

void TouchButton::setThreshold(float level) {
    analogThreshold = level;
}

void TouchButton::setDebounceTime(int t) {
    timeout_ms = t;
}

bool TouchButton::checkState() {
    float diff;
#ifdef DEBUGTOUCH
        com.printf("CHECK BUTTON\r\n");
#endif
 
    charge();
#ifdef DEBUGTOUCH
        com.printf("CHARGE BUTTON\r\n");
#endif    
    sample();
#ifdef DEBUGTOUCH
        com.printf("CHARGE & SAMPLE BUTTON %s\r\n",name);
        com.printf("Value:%3.2f\r\n", currentValue);
#endif


    diff=previousValue - currentValue;
    storeValue();
    if (diff > analogThreshold && timer.read_ms() > timeout_ms) {
        timer.reset();
#ifdef DEBUGTOUCH
        com.printf("TOUCH %s\r\n", name);
#endif
#ifdef DEBUGTOUCHLED
        //Toggle LED to show touch was registered
        if (debugled.read()==1)
            debugled=0;
        else
            debugled=1;
#endif
        return true;
    } else {
        return false;
    }

}

float TouchButton::sample() {

    float sum = 0;
    for (int i=0; i<NUMSAMP;i++) {
        float value = sensor.read();
        sum = sum + value;
    }
    currentValue = sum/NUMSAMP;
    return currentValue;

}

void TouchButton::charge() {
    charger.mode(PullUp);
    charger.mode(PullNone);
    wait(.005);

}
