
#ifndef HANDLER_H
#define HANDLER_H
#include "mbed.h"

#define MATCHSIZE 128
#define STARTCHAR 'S'
#define ENDCHAR   'E'
#define ONECHR '1'
#define ZEROCHR '0'
#define HOSTERROR "HOST ERROR\r\n"

//#define DEBUGHAND

class Handler {

public:
    Handler(char* nm);
    void run();
    bool isReady();
    char *getMatchString();
    void init();

private:
    char *name;
    char matchString[MATCHSIZE];
    char completeMatchString[MATCHSIZE];
    char *pmatchString;
    enum SerialStates { WAITINGON_S, RECIEVING_MATCH};
    SerialStates state;
    enum StringStates { READY, NOTREADY};
    StringStates stringState;
    int value;
    void resetMatch();
    void recieveMatchString(char c);
    void waitForStart(char c);
    void matchStringRecieved();
    void hostError();
    void processChar(char c);
    void recievedStart(char c);
};
#endif