#include "handler.h"
#include "com.h"



Handler::Handler(char *nm) {
    name = nm;
    init();
    stringState=NOTREADY;
}


void Handler::init() {
    #ifdef DEBUGHAND
    com.printf("INIT HANDLER\r\n");
    #endif
    state = WAITINGON_S;
    resetMatch();
}

void Handler::resetMatch() {
    #ifdef DEBUGHAND
    com.printf("RESET MATCH STRING\r\n");
    #endif
    matchString[0]='\0';
    pmatchString = matchString;
}


void Handler::run() {
    int c;
    if (!com.readable()) {
        return;
    }
    c = com.getc();
    
    #ifdef DEBUGHAND
    com.printf("READ CHAR, %c\r\n", c);
    #endif
    
    switch (state) {
        case WAITINGON_S:
            recievedStart(c);
            break;
        case RECIEVING_MATCH:
            processChar(c);
            break;
        default:
            //should not get here
            hostError();
            break;

    }
}

void Handler::processChar(char c) {
    switch (c) {
        case ONECHR:
        case ZEROCHR:
            recieveMatchString(c);
            #ifdef DEBUGHAND
            com.printf("REC 1 or 0\r\n");
            #endif
            break;
        case '\r':
        case ' ':
        case '\n':
            //do nothing
            break;
        case ENDCHAR:
            #ifdef DEBUGHAND
            com.printf("REC E\r\n");
            #endif
            matchStringRecieved();
            break;
        default:
            hostError();
    }
}


void Handler::hostError() {
    com.printf(HOSTERROR);
    init();
}

void Handler::recieveMatchString(char c) {
    *pmatchString = c;
    pmatchString++;
}

void Handler::recievedStart(char c) {
    if (c==STARTCHAR) {
        #ifdef DEBUGHAND
        com.printf("REC S\r\n");
        #endif
        state = RECIEVING_MATCH;
        stringState = NOTREADY;
        resetMatch();
    }
}

void Handler::matchStringRecieved() {
    #ifdef DEBUGHAND
    com.printf("COMPLETE\r\n");
    #endif
    *pmatchString=NULL;
    strcpy(completeMatchString, matchString);
    com.printf("ARMED-%s\r\n",matchString);
    init();
    stringState=READY;
}



bool Handler::isReady() {
    if (stringState==READY) {
        return true;
    } else {
        return false;
    }
}

char *Handler::getMatchString() {
    return completeMatchString;
}
