#ifndef TOUCHMACHINE_H
#define TOUCHMACHINE_H

#include "mbed.h"
#include "touchbutton.h"
#include "handler.h"
#include "com.h"
#define THRESHOLD .45
#define TIMER_THRESHOLD 50
//#define DEBUGTM
//#define DEBUGTM1



class TouchMachine {
    public:
    TouchMachine(char *c);
    void check();
    void run();
    private:
        char *pmatchstr;
        TouchButton *t0;
        TouchButton *t1;
        Handler *hand;
        bool t0state;
        bool t1state;
        enum States {ERROR, WAITING, ONE, ZERO, MATCH};
        States touchState;
        bool isOne();
        bool isZero();
        bool isWaiting();
        bool isError();
        bool isMatch();
        void setMatch();
        char getNextMatchChar();
        char nextMatchChar();
        void setError();
        void resetTouch();
        char getMatchChar();
        void loadMatchStr();
        void touchError();
        void touchMatch();
        void checkTouchForMatch();
        void waitForRelease();
        void checkMatch();
};


#endif