#include "Node.h"

unsigned int crc_table[16] = {
0x00000000, 0x1db71064, 0x3b6e20c8, 0x26d930ac,
0x76dc4190, 0x6b6b51f4, 0x4db26158, 0x5005713c,
0xedb88320, 0xf00f9344, 0xd6d6a3e8, 0xcb61b38c,
0x9b64c2b0, 0x86d3d2d4, 0xa00ae278, 0xbdbdf21c
};

unsigned long crc_update(unsigned long crc, unsigned int data)
{
    char tbl_idx;
    tbl_idx = crc ^ (data >> (0*4));
    crc = crc_table[tbl_idx & 0x0f] ^ (crc >> 4);
    tbl_idx = crc ^ (data >> (1*4));
    crc = crc_table[tbl_idx & 0x0f] ^ (crc >> 4);
    return crc;
}

unsigned long crc_string(char *s) {
    unsigned long crc = ~0L;
    while(*s)
        crc = crc_update(crc, *s++);
    crc = ~crc;
    return crc;
}


unsigned long crc_len(char *s, unsigned int len) {
    unsigned long crc = ~0L;
    for(int idx=0;idx<len;idx++)
        crc = crc_update(crc, *s++);
    crc = ~crc;
    return crc;
}
        
Node::Node(unsigned int n, unsigned int k, PinName pinid) : pin(pinid) {
    setupInputOutput(n,k);
    delay=0;
}

Node::Node(unsigned int n, unsigned int k, PinName pinid, unsigned int delay_ms) : pin(pinid) {
    setupInputOutput(n,k);
    delay=delay_ms;
}

int Node::getSize() {
    return ksize;
}

char *Node::execute(char *data) {
    toggleHigh();
    *tempbuffer=crc_len(data, nsize);
    for(int idx=1;idx<ksize;idx++) {
        *(tempbuffer+idx)=(char)crc_update(0,(*(tempbuffer+idx-1)));
    }
    wait_ms(delay);
    toggleLow();
    return tempbuffer;
}


void Node::setupInputOutput(unsigned int n, unsigned int k) {
    nsize=n;
    ksize=k;
    data_ = (char *)malloc(nsize);
    tempbuffer = (char *)malloc(nsize+ksize);
}

void Node::toggleHigh() {
    pin=1;
}
void Node::toggleLow() {
    pin=0;
}
