#include "mbed.h"
#include "EthernetInterface.h"

// samengewerkt met Robin en Aaron

DigitalOut led(LED1);

int main()
{
    printf("Server example\n\r");
    
    EthernetInterface eth;
    eth.set_network("192.168.0.18","255.255.255.0","192.168.0.1");
    eth.connect();
    
    printf("The Server IP address is '%s'\n\r", eth.get_ip_address());
    
    TCPServer srv(&eth);  
    
    srv.bind(4000);
    
    srv.listen();
    
    while(true){
        TCPSocket client;
        SocketAddress client_addr;
        char *buffer = "Hello TCP client!\r\n";
        
        srv.accept(&client, &client_addr);
        
        printf("Accepted %s:%d\n\r", client_addr.get_ip_address(), 
                    client_addr.get_port());
                    
        client.send(buffer, 256);
        
        char rbuffer[64];
        int rcount = client.recv(rbuffer, sizeof rbuffer);
        
        uint16_t tempLowHigh = ((rbuffer[1] & 0xFF) << 8 ) | (rbuffer[2] & 0xFF);
        tempLowHigh =  tempLowHigh >> 5;
        
            //Sign extend negative numbers
        if (tempLowHigh & (1 << 10)){
            
            tempLowHigh |= 0xFC00;
            
            }

        //Return the temperature in °C
         float temperature = tempLowHigh * 0.125;
        
        printf("received: %d\r\n", rcount);
        printf("packet PWM: %d\r\n", rbuffer[0]);
        printf("packet temp: %d\r\n", temperature);
        
        client.close();
        
    }
}