/* Hello World! for the TextLCD Enhanced Library*/

#include "mbed.h"
#include "TextLCD.h"
 
// Host PC Communication channels
Serial pc(USBTX, USBRX); // tx, rx
 
// I2C Communication
I2C i2c_lcd(D15,D14); // SDA, SCL
//I2C i2c_lcd(p28,p27); // SDA, SCL
 
// SPI Communication
//SPI spi_lcd(p5, NC, p7); // MOSI, MISO, SCLK

// LCD instantiation 
//TextLCD lcd(p15, p16, p17, p18, p19, p20, TextLCD::LCD20x2);        // 4bit bus: rs, e, d4-d7
TextLCD_I2C lcd(&i2c_lcd, 0x7E, TextLCD::LCD20x4);                  // I2C exp: I2C bus, PCF8574 Slaveaddress, LCD Type
//TextLCD_I2C lcd(&i2c_lcd, 0x7E, TextLCD::LCD16x2, TextLCD::HD44780); // I2C exp: I2C bus, PCF8574 Slaveaddress, LCD Type, Ctrl Type
//TextLCD_I2C lcd(&spi_lcd, p8, TextLCD::LCD24x4D);                   // I2C exp: SPI bus, CS pin, LCD Type
//TextLCD_SPI_N lcd(&spi_lcd, p8, p9, TextLCD::LCD16x2, NC, TextLCD::ST7032_3V3); // SPI native: SPI bus, CS pin, RS pin, LCDType=LCD16x2, BL=NC, LCDTCtrl=ST7032
//TextLCD_I2C_N lcd(&i2c_lcd, ST7032_SA, TextLCD::LCD16x2, NC, TextLCD::ST7032_3V3); // I2C native: I2C bus, slaveaddress, LCDType=LCD16x2, BL=NC, LCDTCtrl=ST7032 =Ok
//TextLCD_I2C_N lcd(&i2c_lcd, SSD1803_SA1, TextLCD::LCD20x4D, NC, TextLCD::SSD1803_3V3); // I2C native: I2C bus, slaveaddress, LCDType=LCD20x4D, BL=NC, LCDTCtrl=SSD1803 =Ok
 
int main() {   
  Timer t;

  pc.printf("TextLCD Enhanced Test. Columns=%d, Rows=%d\n\r", lcd.columns(), lcd.rows());
    
  for (int row=0; row<lcd.rows(); row++) {
    int col=0;
      
    pc.printf("MemAddr(Col=%d, Row=%d)=0x%02X\n\r", col, row, lcd.getAddress(col, row));      
//    lcd.putc('-');
    lcd.putc('0' + row);      
      
    for (col=1; col<lcd.columns()-1; col++) {    
      lcd.putc('*');
    }
 
    pc.printf("MemAddr(Col=%d, Row=%d)=0x%02X\n\r", col, row, lcd.getAddress(col, row));      
    lcd.putc('+');       
  }    

// Fill screen again and time it
  t.start();

  for (int row=0; row<lcd.rows(); row++) {
    int col=0;
      
    lcd.putc('0' + row);      
      
    for (col=1; col<lcd.columns()-1; col++) {    
      lcd.putc('*');
    }
 
    lcd.putc('+');       
  }    
  t.stop();    
  pc.printf("All my hard work took %f sec\r\n", t.read());          

// Show cursor as blinking character
   lcd.setCursor(TextLCD::CurOff_BlkOn);
 
// Set and show user defined characters. A maximum of 8 UDCs are supported by the HD44780.
// They are defined by a 5x7 bitpattern. 
  lcd.setUDC(0, (char *) udc_0);  // Show |>
  lcd.putc(0);    
  lcd.setUDC(1, (char *) udc_1);  // Show <|
  lcd.putc(1);    
    
  pc.printf("Bye now\r\n");          
}



