#include "mbed.h"
//Program to 'sweep' test a 'standard RC type servo
//Define some parameters using compiler directive '#define'
//Check Servo DATA if 0.75ms to 2.25ms then use min=750 and max=2250
//NB be values in microseconds (Following are generic values)
#define MID         1500
#define MIN         1000
#define MAX         2000
#define STEP          50
//Time delay between steps in milliseconds
#define TIME         400
 
DigitalOut myLed(LED1);
DigitalIn  myButton(USER_BUTTON);
 
PwmOut myServo(D11);
 
int main() {
    
    myServo.period_ms(20);
    myServo.pulsewidth_us(MID); //NB in microseconds
 
    while(true) {
        for (int i=MIN;i<=MAX;i+=STEP){
            myServo.pulsewidth_us(i);
            wait_ms(TIME);
        }
        for (int i=MAX;i>=MIN;i-=STEP){
            myServo.pulsewidth_us(i);
            wait_ms(TIME);
        }
    }
}