#include "mbed.h"
#include "BufferedSerial.h"
#include "rplidar.h"
#include "Robot.h"
#include "Communication.h"
#include "Functions.h"
#include <math.h>
#include <stdio.h>
#include <stdlib.h>

#define PI 3.141592654

Serial pc(SERIAL_TX, SERIAL_RX);
RPLidar lidar;
BufferedSerial se_lidar(PA_9, PA_10);
PwmOut rplidar_motor(D3);

void bresenham(float poseX, float poseY, float xf, float yf, float z);

float MapaLog[40][40] = {0};
float Mapa40[40][40];

int main() {
    pc.baud(115200);
    init_communication(&pc);
    
    DigitalIn UserButton(USER_BUTTON); // Initialize Button
    DigitalOut myled(LED1); // Initialize LED
    
    // PARAMETROS CONSTANTES
    float T = 0.5;
    float wheelsRadius = 3.5;
    float wheelsDistance = 13.5;
    
    // Variaveis
    float k_v = 15; // 15
    float k_i = 0.3; //0.1
    float k_s = 11; //20
    float v_erro = 15;
    
    int   DPontos = 2; //distância de erro
    
    float RectSize = 4.0;
    float FCRepul = -1000; // Forca de Repulsao
    float FCAtracao = 5; // Forca de Atracao
    
    float pose[3] = {30, 15, 0}; // Ponto Inicial
    float pose_f[3] = {60,100,0}; // Ponto Objetivo
    
    float errot = 0, erro = 0, erro_old = -1;
    float Forcas[4] = {0, 0, 0, 0};
    
    float vRobot, wRobot, Norma, angForca, phi, w[2], ForcaResult[2], PIntermedio[2];
    
    float LidarP[2]; // pontos na plataforma
    float LidarW[2]; // pontos no mundo
    
    // matriz rotacao world plataforma
    float R_WP[3][3]= {{cos(pose[2]), -sin(pose[2]), pose[0]},
                        {sin(pose[2]), cos(pose[2]), pose[1]},
                        {0, 0, 1}};
    
    struct RPLidarMeasurement data;
    
    //Inicializar Mapa das probabilidades a 0.5
    for(int i=0; i<40; i++)
        for(int j=0; j<40; j++)
            Mapa40[i][j]=0.5;
    
    int leituras = 0; long dist;
    
    // Lidar initialization
    rplidar_motor.period(0.001f);
    //rplidar_motor.write(0.5f);
    lidar.begin(se_lidar);
    lidar.setAngle(0, 360);
            
    
    setSpeeds(0, 0);
    
    pc.printf("waiting...\n\r");

    int start = 0;
    while(start != 1) {
        myled=1;
        if (UserButton == 0) { // Button is pressed
            myled = 0;
            start = 1;
            rplidar_motor.write(0.5f);
        }
    }
    
    lidar.startThreadScan();
    
    while(leituras < 1000){
        if(lidar.pollSensorData(&data) == 0)
        {           
            //pc.printf("%f\t%f\n\r", data.distance, data.angle); // Prints one lidar measurement.
            
            float radians = (data.angle * static_cast<float>(PI))/180.0f;
            
            dist = data.distance/10.0f;
            
            LidarP[0] = -dist*sin(radians)- 2.8f;
            LidarP[1] = -dist*cos(radians)- 1.5f;

            //W_P = R_WP * p_P
            LidarW[0] = LidarP[0]* R_WP[0][0] + LidarP[1]* R_WP[0][1] + R_WP[0][2]; // coordenadas no mundo, ou seja, cm
            LidarW[1] = LidarP[0]* R_WP[1][0] + LidarP[1]* R_WP[1][1] + R_WP[1][2];
            
            // pontos onde o feixe passou
            bresenham(pose[0]/5, pose[1]/5, LidarW[0]/5, LidarW[1]/5, data.distance/5);
            
            leituras++;
        }
    }
    
    for(int f = 0; f < 40; f++){
        for(int g = 0; g < 40; g++){
            if(Mapa40[f][g] < 0.65f)
                pc.printf("0 ");
            else
                pc.printf("1 ");
        }
        pc.printf("nova linha \n\r");
    }
    
    start = 0;
    while(start != 1) {
        myled=1;
        if (UserButton == 0) { // Button is pressed
            myled = 0;
            start = 1;
            rplidar_motor.write(0.5f);
        }
    }
    
    pc.printf("Running\n\r");

    while(sqrt(pow(pose_f[1]-pose[1],2)+pow(pose_f[0]-pose[0],2)) > 5.0f) {
          
        getCountsAndReset(); // Call getCountsAndReset() to read the values of encoders
                             // and reset them. The values become available on variables
                             // "countsLeft" and "countsRight".
        
        //if(sqrt(pow(pose_f[1]-pose[1],2)+pow(pose_f[0]-pose[0],2)) > 13){
            
            pc.printf("x; %f, y: %f\n\r", pose[0], pose[1]);
            
            JanelaAtivaVFF(pose, Mapa40, pose_f, FCRepul, FCAtracao, RectSize, Forcas);
            
            ForcaResult[0] = Forcas[0]+Forcas[2]; // componente de x
            ForcaResult[1] = Forcas[1]+Forcas[3]; // componente de y
    
            Norma = sqrt(pow(ForcaResult[0],2) + pow(ForcaResult[1],2));
            ForcaResult[0] = ForcaResult[0]/Norma; // Normalização da forca resultante entre a forca de repulsão e a forca de atracão
            ForcaResult[1] = ForcaResult[1]/Norma;
    
            // Angulo da forca resultante
            angForca = atan2(ForcaResult[1], ForcaResult[0]);
        //}
        //else
            //angForca = atan2(pose_f[1] - pose[1], pose_f[0] - pose[0]);
        
        
        PIntermedio[0] = pose[0] + v_erro * cos(angForca);
        PIntermedio[1] = pose[1] + v_erro * sin(angForca);
        
        erro = sqrt(pow(PIntermedio[1]-pose[1], 2)+ pow(PIntermedio[0]-pose[0],2)) - DPontos;
        
        if(erro_old == -1){
            erro_old = erro;    
        }
        
        errot = errot + (erro + erro_old) * T/2.0f;
        
        //Velocidade do Robo
        vRobot = k_v * erro + k_i * errot;
        
        erro_old = erro;
        
        phi = atan2((PIntermedio[1]-pose[1]), (PIntermedio[0]-pose[0])); // Angulo entre o ponto intermedio e o robo
        
        wRobot = k_s * atan2(sin(phi-pose[2]), cos(phi-pose[2])); //velocidade angular do robo;
              
        // Velocidades das rodas
        velRobot2velWheels(vRobot,wRobot,wheelsRadius,wheelsDistance,w);
        
        if (w[0] > 200)
            w[0]=200;
            
        if (w[1] > 200)
            w[1]=200;
        
        setSpeeds(w[0], w[1]);
        
        nextPose(countsLeft, countsRight, wheelsRadius, wheelsDistance, pose);
        
        leituras = 0;
        
        while(leituras < 5){
            if(lidar.pollSensorData(&data) == 0)
            {           
                //pc.printf("%f\t%f\n\r", data.distance, data.angle); // Prints one lidar measurement.
                
                float radians = (data.angle * static_cast<float>(PI))/180.0f;
                
                LidarP[0] = -data.distance*sin(radians)- 2.8f;
                LidarP[1] = -data.distance*cos(radians)- 1.5f;
    
                //W_P = R_WP * p_P
                LidarW[0] = LidarP[0]* R_WP[0][0] + LidarP[1]* R_WP[0][1] + R_WP[0][2]; // coordenadas no mundo, ou seja, cm
                LidarW[1] = LidarP[0]* R_WP[1][0] + LidarP[1]* R_WP[1][1] + R_WP[1][2];
                
                // pontos onde o feixe passou
                bresenham(pose[0]/5.0f, pose[1]/5.0f, LidarW[0]/5.0f, LidarW[1]/5.0f, data.distance/5.0f);
                
                leituras++;
            }
        }
            
        wait(T); // Delay of 0.5 seconds.
    }
    myled=1;
    setSpeeds(0, 0);
    rplidar_motor.write(0.0f);
}

void bresenham(float poseX, float poseY, float xf, float yf, float z){
    int T, E, A, B;
    
    int x = static_cast<int>(poseX);
    int y = static_cast<int>(poseY);
    int dx = abs(static_cast<int>(xf - poseX));
    int dy = abs(static_cast<int>(yf - poseY));
    
    int s1;
    int s2;
    // substitui o sign() do matlab
    if(static_cast<int>(xf - poseX) > 0)
        s1 = 1;
    else if (static_cast<int>(xf - poseX) == 0)
        s1 = 0;
    else
        s1 = -1;
        
    if(static_cast<int>(yf - poseY) > 0)
        s2 = 1;
    else if (static_cast<int>(yf - poseY) == 0)
        s2 = 0;
    else
        s2 = -1;
 
    
    int interchange = 0;
    
    if (dy > dx){
        T = dx;
        dx = dy;
        dy = T;
        interchange = 1;
    }
    
    E = 2*dy - dx;
    A = 2*dy;
    B = 2*dy - 2*dx;
    
    for (int i = 0; i<dx; i++){
        if (E < 0){
            if (interchange == 1){
                y = y + s2;
            }
            else{
                x = x + s1;
            }
            E = E + A;
        }
        
        else{
            y = y + s2;
            x = x + s1;
            E = E + B;
        }
        
        if (x >= 0 && y >= 0 && x < 40 && y < 40){
            // Mapear mapa do Logaritmo
            MapaLog[x][y] = MapaLog[x][y] + Algorithm_Inverse(poseX, poseY, x, y, z);
            //pc.printf("%f %f\n\r", MapaLog[x][y], 1 - 1/(1+exp(MapaLog[x][y])));
            Mapa40[x][y] = 1 - 1/(1+exp(MapaLog[x][y]));
        }
        
        
                  
    }
}