#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"
#include "RPCFunction.h"
#include "NTPClient.h"

EthernetNetIf eth;
NTPClient ntp;
HTTPServer svr;

DigitalOut led1(LED1, "led1");
DigitalOut led2(LED2, "led2");
DigitalOut led3(LED3, "led3");
DigitalOut led4(LED4, "led4");

AnalogIn Sensor(p20);                              // Sensor in
DigitalOut pin15(p15);
DigitalOut pin16(p16);
DigitalOut pin17(p17);
DigitalOut pin18(p18);
DigitalOut pin19(p19);

FILE *file;

int main()
{

    /************** Ethernet Setup *****************/
    EthernetErr ethErr;
    int count = 0;
    do {
        printf("Setting up %d...\n\r", ++count);
        ethErr = eth.setup();
        if (ethErr) printf("Timeout\n\r", ethErr);
    } while (ethErr != ETH_OK);

    printf("Connected OK\n\r");
    const char* hwAddr = eth.getHwAddr();

    IpAddr ethIp = eth.getIp();
    printf("IP address : %d.%d.%d.%d\n\r", ethIp[0], ethIp[1], ethIp[2], ethIp[3]);

    /***************** FilsSystem ******************/
    LocalFileSystem local("local");
    float waarden[3][800];

    /***************** Handlers *******************/
    svr.addHandler<SimpleHandler>("/hello");
    svr.addHandler<FSHandler>("");
    svr.addHandler<RPCHandler>("/rpc");

    FSHandler::mount("/webfs", "/"); //Mount /webfs path on web root path
    Base::add_rpc_class<DigitalOut>();
    Base::add_rpc_class<AnalogIn>();

    svr.bind(80);
    printf("Server listening\n\r");

    /**************** Realtime clock ******************/
    time_t ctTime;
    ctTime = time(NULL);
    printf("Current time is (UTC): %s\r\n", ctime(&ctTime));

    Host server(IpAddr(), 123, "be.pool.ntp.org");
    //be server: be.pool.ntp.org
    ntp.setTime(server);

    ctTime = time(NULL);
    printf("\nTime is now (UTC): %s\r\n", ctime(&ctTime));

    /***************** Timer ***************/
    Timer tm;
    tm.start();

    float sensorWaarde;


    while (true) {
        Net::poll();
        if (tm.read() > 2) {
            file = fopen("/local/test.htm", "a");                       //openen bestand.
            sensorWaarde = ((Sensor * 3.3 -2.78)*100);                  //Ijking waarde
            ctTime = time(NULL);                                        //Tijd goedzetten
            fprintf(file, "%s %5.2f\r\n", ctime(&ctTime), sensorWaarde);
            printf("\nTime is now (UTC): %s\r\n", ctime(&ctTime));
            printf("Temperatuur: %5.2f\r\n", sensorWaarde);
            fclose(file);
            led1 = !led1;
            tm.start();
        }
    }
}