//********************************
// Matthias Hemmer, 14.12.2015
// Creator: Dominik Sukic 30.11.2015
// Desing; EB 14.12.2015
//
// Create a PWM with delay
// For LEDs 1 to 4 BERTL14
//
//**********************************


#include "mbed.h"           // Include thbe "mbed.h" libary

#define PWM_Periode 125    // Defination of the periode

// Defination of LEDs
DigitalOut Led1(P1_8);  // Name(Port)
DigitalOut Led2(P1_9);  // Name(Port)
DigitalOut Led3(P1_10); // Name(Port)
DigitalOut Led4(P1_11); // Name(Port)

// BEGIN pwm_delay
// dutycycle: 0 - MAX; the brightness of the LEDs
// on: 1 - 4; to turn each LED on
void pwm_delay(unsigned int dutycycle, int LED_index)   //PWM underprogramm
{
    int PWM_time_index = 0;
    
    // Loop to increase PWM-Time to 1 ms (PWM_time_index x 250µs)
    for (PWM_time_index = 0; PWM_time_index < 4; PWM_time_index++)
    {
        switch(LED_index)
        {
            case 1:     // pwm for LED1
                Led1 = 1;
                wait_us(dutycycle); //Time which the LED is powered
                Led1 = 0;
                wait_us(250-dutycycle); //Time which the LED is unpowered
            break;
            
            case 2:     // pwm for LED2
                Led2 = 1;
                wait_us(dutycycle); //Time which the LED is powered
                Led2 = 0;
                wait_us(250-dutycycle); //Time which the LED is unpowered
            break;
            
            case 3:     // pwm for LED3
                Led3 = 1;
                wait_us(dutycycle); //Time which the LED is powered
                Led3 = 0;
                wait_us(250-dutycycle); //Time which the LED is unpowered
            break;
        
            case 4:     // pwm for LED4
                Led4 = 1;
                wait_us(dutycycle); //Time which the LED is powered
                Led4 = 0;
                wait_us(250-dutycycle); //Time which the LED is unpowered
            break;
            
            default:    // if the nummber isn't listed, it woudn't crash
                ;
            break;
        }
        // End switch
    }
    // END for
}
// END pwm_delay


// BEGIN main
// Call pwm_delay for testing
// all 4 Leds pwm-dimmed, phase-shifted
int main()
{
    // all LEDs off
    Led1 = 0;
    Led2 = 0;
    Led3 = 0;
    Led4 = 0;
    
    // Initial Brightness for each LED
    int dutycycle1 = 0; // Brightness in %
    int dutycycle2 = 25;
    int dutycycle3 = 50;
    int dutycycle4 = 75;
    
    // Define direction of dimming
    
    //Bools for brighter or darker
    bool led1_darker = false; //If false => brighter
    bool led2_darker = false; //Wenn true => darker
    bool led3_darker = false; 
    bool led4_darker = false;

    // central routine for triangle-dimming
    while(1)
    {  
        //Led1
        if(led1_darker == false)
        { //False: Led is getting brighter
            
            if (dutycycle1 != PWM_Periode)
            {
            pwm_delay(dutycycle1,1); //Call the underprogramm PWM
            dutycycle1++; //Brightness rice up
            }
            
            else
                led1_darker = true; //Led 1 = true: it will be darker
        }
        if(led1_darker == true)
        { 
            //True: Led is getting darker
            if (dutycycle1 != 0) 
            {
                pwm_delay(dutycycle1,1); 
                dutycycle1--; //brightness rice down    
            }
            
            else
                led1_darker = false; //To make it brighter
        }
        
        //Repead it for each LED

        //Led2 brighter
        if(led2_darker == false) 
        {
            if (dutycycle2 != PWM_Periode)
            {
                pwm_delay(dutycycle2,2);
                dutycycle2 ++;
            } 
            else
                led2_darker = true;
        }
        
        //Led2 darker
        if(led2_darker == true) 
        {
            if (dutycycle2 != 0) 
            {
                pwm_delay(dutycycle2,2);
                dutycycle2 --;
            } 
            else 
                led2_darker = false;
        }

        //Led3 brighter       
        if(led3_darker == false)
         {
            if (dutycycle3 != PWM_Periode)
            {
                pwm_delay(dutycycle3,3);
                dutycycle3 ++;
            } 
            else 
                led3_darker = true;
        }
        
        //Led3 darker
        if(led3_darker == true) 
        {
            if (dutycycle3 != 0) 
            {
                pwm_delay(dutycycle3,3);
                dutycycle3 --;
            } 
            else 
                led3_darker = false;
        }
        
        //Led4 brighter
        if(led4_darker == false)
         {
            if (dutycycle4 != PWM_Periode) 
            {
                pwm_delay(dutycycle4,4);
                dutycycle4 ++;
            } 
            else 
                led4_darker = true;
        }
        
        //Led4 darker
        if(led4_darker == true) 
        {
            if (dutycycle4 != 0) 
            {
                pwm_delay(dutycycle4,4);
                dutycycle4 --;
            } 
            else
                led4_darker = false;
        }
        
    }   // End of While
}   // En dof Main