#ifndef MBED_PCF8563_H
#define MBED_PCF8563_H

#include "mbed.h"

#define PCF8563_FREQ     400000  // bus speed 400 kHz

class PCF8563
{
public:
    //define the i2c pins
    PCF8563(PinName sda, PinName scl);
    /**read from an I2C address
     *@para: the read address of the I2C device
     *@param: for only one i2c address of the device
     */
    uint8_t read(int i2c_r,int address);  //read class
    /**read from an I2C address
     * for two different parameters
     *@param: the write address of the I2C device
     *@param: the read address of the I2C device
     *@param: the register where you will read from
     */ 
    uint8_t read(int i2c_w, int i2c_r, int address);  //read class
    /**wirte from an I2C address
     *@param: the write address of the I2C device
     *@param: a register address of the I2C device
     *@param: set a value to this address of th I2C device
     */
    void write(int i2c_w, int address, int value);  //write class
    /**convert from Binary Coded Decimal to Decimal
     *@param: set a value which must be converted
     *returns a Decimal value
     */
    uint8_t bcdToDec(uint8_t val);  //convertation from bcd to dec

private:
    I2C i2c;    //unsing the i2c library
};
#endif