#include "myi2c.h"

PCF8563::PCF8563(PinName sda, PinName scl) : i2c (sda, scl)
{
    i2c.frequency(PCF8563_FREQ);        //set the frequency
}
/*
 * read function from the TRC
 * read a value and return it
 */
uint8_t PCF8563::read(int i2c_r, int address)
{
    uint8_t value; //temp 8bit
    i2c.start();    //start
    i2c.write(i2c_r);  //write address
    i2c.write(address);
    i2c.start();    //restart
    i2c.write(address);  //read address
    value = i2c.read(0);
    i2c.stop();

    return value;   //returns var value of the method
}
uint8_t PCF8563::read(int i2c_w, int i2c_r, int address)
{
    uint8_t value; //temp 8bit
    i2c.start();    //start
    i2c.write(i2c_w);  //write address
    i2c.write(address);
    i2c.start();    //restart
    i2c.write(i2c_r);  //read address
    value = i2c.read(0);
    i2c.stop();
    return value;
}
/* firtly you write the address from the rtc
 * secondly the register address
 * last but not leat your value
 */
void PCF8563::write(int i2c_w, int address, int value)
{
    i2c.start();    //start
    i2c.write(i2c_w);  //i2c write address
    i2c.write(address);
    i2c.write(value);
    i2c.stop(); //stop
}
/*
 * Binary Coded Decimal converter into decimal
 */
uint8_t PCF8563::bcdToDec(uint8_t val)
{
    return (10*((val>>4)& 0x0F)+(val & 0x0F));      //convert from bcd to dec
}
