#include "mbed.h"

// LED-Defines
#define LED_FL_WHITE    0x01 // 0b0000 0001
#define LED_FR_WHITE    0x04 // 0b0000 0100
#define LED_FL_ORANGE   0x02 // 0b0000 0010
#define LED_FR_ORANGE   0x08 // 0b0000 1000
#define LED_BL_ORANGE   0x20 // 0b0010 0000
#define LED_BR_ORANGE   0x80 // 0b1000 0000
#define LED_BL_RED      0x10 // 0b0001 0000
#define LED_BR_RED      0x40 // 0b0100 0000

#define LED_L_ORANGE (LED_FL_ORANGE | LED_BL_ORANGE) // 0b0000 0010 | 0b0010 0000 = 0b0010 0010
#define LED_R_ORANGE (LED_FR_ORANGE | LED_BR_ORANGE) // right blinkers    
#define LED_WHITE    (LED_FL_WHITE  | LED_FR_WHITE)  // front light
#define LED_RED      (LED_BL_RED    | LED_BR_RED)    //back light

#define SW_FM 0x04
#define SW_FL
#define SW_FR
#define SW_F (SW_FM|SW_FL|SW_FR)

// PC9555-defines
#define PC9555_ADDR 0x40 // A2 = A1 = A0 = 0
#define PC9555_FREQUENCY 100000 // f in Hz

//PC9555 Commands
#define PC9555_Port0_IN (0)
#define PC9555_Port1_IN (1)
#define PC9555_Port0_OUT (2)
#define PC9555_Port1_OUT (3)
#define PC9555_Port0_INV (4)
#define PC9555_Port1_INV (5)
#define PC9555_Port0_DIR_IN (6)
#define PC9555_Port1_DIR_IN (7)

void bertl_PC9555_init();
void bertl_PC9555_leds(unsigned char leds);
unsigned char bertl_PC9555_switches();