#include "mbed.h"
#include "I2C.h"

I2C pc9555 (p28, p27);    //SDA,SCL

void bertl_PC9555_init()
{
    char data[2];
    
    // I2C Initialisierung
    pc9555.frequency(PC9555_FREQUENCY);
    
    // Port 0 = LEDs
    
    // Adresse, RW# = 0, Config Port 0 (6) = 0x00 (=OutPut), Stop
    data[0] = PC9555_Port0_DIR_IN;
    data[1] = 0x00;     // Output    
    pc9555.write(PC9555_ADDR, data, 2);  
    
    // Adresse, RW# = 0, Config Port 1 (7) = 0x00 (=InPut), Stop
    data[0] = PC9555_Port1_DIR_IN;
    data[1] = 0xFF;     // Input
    pc9555.write(PC9555_ADDR, data, 2);  
    
    // Adresse, RW# = 0, Polarity Inversion Port 0 (4) = 0xFF (= inverted) , Stop  
    data[0] = PC9555_Port0_INV;
    data[1] = 0xFF;
    pc9555.write(PC9555_ADDR, data, 2); 
    
     // Adresse, RW# = 0, Polarity Inversion Port 1 (5) = 0x00 (=NonInverted) , Stop
    data[0] = PC9555_Port1_INV;
    data[1] = 0x00;
    pc9555.write(PC9555_ADDR, data, 2);      
}

void bertl_PC9555_leds(unsigned char leds)
{
    char data[2];   // Two Bytes for Transmitt via I2C
    
    // Send leds to Port0 of PC9555 tp I2C: 
    // Start, Adress, RW# = 0, CMD I2C_Port0_OUT , leds, Stop
    data[0] = PC9555_Port0_OUT;
    data[1] = ~leds;        //bitwise inversion since HW is switched on with 0 (invers logic)
    pc9555.write(PC9555_ADDR, data, 2);
}

unsigned char bertl_PC9555_switches()
{
    char data[1];
    data[0] = PC9555_Port1_IN;
    pc9555.write(PC9555_ADDR, data, 1, true); // tell him, we want to read Port1, no STOP
    pc9555.read(PC9555_ADDR, data, 1, false); // read 1 byte, then send STOP
    return((unsigned char) data[0]);
}