

// Definieren der Input port registers
#define Port0_InPut     (0)
#define Port1_InPut     (1)

// Definieren der Outout port registers
#define Port2_OutPut    (2)
#define Port3_OutPut    (3)

// Definieren der Polaroty Inversion registers
#define Port4_PolarityInvert    (4)
#define Port5_PolarityInvert    (5)

// Definieren der Configuration registers
#define Port6_Config    (6)
#define Port7_Config    (7)

// PC9555-defines
#define PC9555_ADDR 0x40 // A2 = A1 = A0 = 0
#define PC9555_FREQUENCY 100000 // f in Hz

// LED-Defines
#define LED_FL_WHITE    0x01 // 0b0000 0001
#define LED_FR_WHITE    0x04 // 0b0000 0100
#define LED_FL_ORANGE   0x02 // 0b0000 0010
#define LED_FR_ORANGE   0x08 // 0b0000 1000
#define LED_BL_ORANGE   0x20 // 0b0010 0000
#define LED_BR_ORANGE   0x80 // 0b1000 0000
#define LED_BL_RED      0x10 // 0b0001 0000
#define LED_BR_RED      0x40 // 0b0100 0000

#define LED_L_ORANGE (LED_FL_ORANGE | LED_BL_ORANGE) // 0b0000 0010 | 0b0010 0000 = 0b0010 0010
#define LED_R_ORANGE (LED_FR_ORANGE | LED_BR_ORANGE) // right blinkers    
#define LED_WHITE    (LED_FL_WHITE  | LED_FR_WHITE)  // front light
#define LED_RED      (LED_BL_RED    | LED_BR_RED)    //back light

void PC9555_init();
void LEDs(unsigned char led);
unsigned char Switch();