#include "mbed.h"
#include "I2C.h"

I2C i2c(p28, p27);

void PC9555_init(){
        
        char data[2];       // Initialisierung der Befehle/Zustände
        
//------------------------Port 0----------------------------------------------------------------               
        // Definieren der Befehle/Zustände
        data[0] = Port0_InPut;  // Zuerst die gewünschte Adresse       
        data[1] = 0x00;         // Wird als Ausgang definiert (Zustand definieren)
            
        i2c.write(PC9555_ADDR, data, 2);        // Schreiben auf die Adresse des I2C's
//------------------------Port 1----------------------------------------------------------------        
        data[0] = Port1_InPut;
        data[1] = 0x00;

        i2c.write(PC9555_ADDR, data, 2);
 //------------------------Port 2----------------------------------------------------------------       
        data[0] = Port2_OutPut;
        data[1] = 0x00;

        i2c.write(PC9555_ADDR, data, 2);
//------------------------Port 3----------------------------------------------------------------
       data[0] = Port3_OutPut;
       data[1] = 0x00;
       
       i2c.write(PC9555_ADDR, data, 2);
//------------------------Port 4----------------------------------------------------------------
       data[0] = Port4_PolarityInvert;
       data[1] = 0xFF;      // Würde dies als Eingang setzten, aber diese eingänge sind Invertiert
       
       i2c.write(PC9555_ADDR, data, 2);
//------------------------Port 5----------------------------------------------------------------
       data[0] = Port5_PolarityInvert;
       data[1] = 0xFF;
       
       i2c.write(PC9555_ADDR, data, 2);
//------------------------Port 6----------------------------------------------------------------
       data[0] = Port6_Config;
       data[1] = 0x00;
       
       i2c.write(PC9555_ADDR, data, 2);
//------------------------Port 7----------------------------------------------------------------
       data[0] = Port7_Config;
       data[1] = 0x00;
       
       i2c.write(PC9555_ADDR, data, 2);
//------------------------Ende------------------------------------------------------------------    
}// Ende bertl_PC9555_init

void LEDs(unsigned char led){
    char data[2];
    
    data[0] = Port2_OutPut;
    data[1] = ~led;
    
    i2c.write(PC9555_ADDR, data, 2);
}// Ende LEDs

unsigned char Switch(){
    
    char data[1];
    
    data[0] = Port1_InPut;
    i2c.write(PC9555_ADDR, data, 1, true); // Schreiben eines Bits, nicht STOPEN
    i2c.read(PC9555_ADDR, data, 1, false); // Lesen eines Bits und dann STOPEN
    
    return((unsigned char) data[0]);
}// Ende Switch    
    
    
    
    
    
    
    