#include "mbed.h"
#include "x_nucleo_ika01a1_class.h"

Serial pc(USBTX, USBRX);

DigitalOut myled(LED1);

int main() {  
    X_NUCLEO_IKA01A1 *analog_expansion_board = X_NUCLEO_IKA01A1::Instance();
    analog_expansion_board->Init();
    TSV734 *led_Driver = analog_expansion_board->tsv734;  
    led_Driver->Configure(D3, 50);  
    float dutyCycle_us = 0;
       
    while(1) {        
        pc.printf("\nwhile loop\n");        
        dutyCycle_us += 10;  
        pc.printf("\nLED Driver: duty cycle: %u percent \n", led_Driver->SetDutyCycle(dutyCycle_us));              
        
        if(dutyCycle_us>=100) 
            dutyCycle_us -= 100;
                                  
        myled = !myled;
        wait(1);
    }    
}
