#include "UseCases.h"

#include "mbed.h"

DigitalOut myled(LED1);

#include "debug.h"
#include "btle.h"
#include "BLEDevice.h"
#include "UUID.h"
#include "Utils.h"

BLEDevice dev;

const static char  DEVICE_NAME[] = "HEALTH_DEVICE";
//const uint8_t device_address[6] = { 0x12, 0x34, 0x00, 0xe1, 0x80, 0x02 }; //Peripheral address

void Append128bitUUID(uint8_t *uuid128_list, const LongUUID_t HRM_SERVICE_UUID_128);
void print_array(uint8_t *array);

#define MAX_SERVICES_NOS 1                                                                                                                                       
//typedef uint8_t UUID_128_BIT[16]; 
const LongUUID_t HEART_RATE_CHAR_UUID_128 = {0x42,0x82,0x1a,0x40, 0xe4,0x77, 0x11,0xe2, 0x82,0xd0, 0x00,0x02,0xa5,0xd5,0xc5,0x1a};
const LongUUID_t HRM_SERVICE_UUID_128 = {0x42,0x82,0x1a,0x40, 0xe4,0x77, 0x11,0xe2, 0x82,0xd0, 0x00,0x02,0xa5,0xd5,0xc5,0x1b};

uint8_t UUID_Count=0;

static uint8_t hrmCounter = 100;
static uint8_t bpm[2] = {0x00, hrmCounter};
//static uint8_t hcpCounter = 99;
static uint8_t hcp[2] = {0x00, hrmCounter};

GattCharacteristic hrmRate(GattCharacteristic::UUID_HEART_RATE_MEASUREMENT_CHAR, bpm, sizeof(bpm), sizeof(bpm), 
                            GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY|GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ);

GattCharacteristic hcpControlPoint(GattCharacteristic::UUID_HEART_RATE_CONTROL_POINT_CHAR, hcp, sizeof(hcp), sizeof(hcp), 
                            GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE_WITHOUT_RESPONSE|
                            GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE);                            
                            

GattCharacteristic *hrmChars[] = {&hrmRate, &hcpControlPoint};
UUID HRMSERVICE(GattService::UUID_HEART_RATE_SERVICE);
GattService hrmService(HRMSERVICE/*GattService::UUID_HEART_RATE_SERVICE*/, hrmChars, sizeof(hrmChars) / sizeof(GattCharacteristic *));

/* BP Service definition */
static uint8_t bpValue = 110;
static uint8_t bloodPressure[2] = {bpValue, 0x00};
static uint8_t bpDevFeature[2] = {0x00, bpValue};

GattCharacteristic bpMeasurment(GattCharacteristic::UUID_GLUCOSE_MEASUREMENT_CHAR, bloodPressure, sizeof(bloodPressure), sizeof(bloodPressure), 
                            GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY|GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ);

GattCharacteristic bpFeature(GattCharacteristic::UUID_GLUCOSE_FEATURE_CHAR, bpDevFeature, sizeof(bpDevFeature), sizeof(bpDevFeature), 
                            GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE_WITHOUT_RESPONSE|
                            GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE);                            
                            

GattCharacteristic *bpChars[] = {&bpMeasurment, &bpFeature};
UUID BP_SERVICE(GattService::UUID_GLUCOSE_SERVICE);
GattService bpService(BP_SERVICE, bpChars, sizeof(bpChars) / sizeof(GattCharacteristic *));


/* battery Service definition */
static uint8_t batteryValue = 0;
static uint8_t batteryCharge[3] = {batteryValue, 0x00, 0x00};
static uint8_t batteryState[2] = {0x00, batteryValue};

GattCharacteristic batteryChargeChar(GattCharacteristic::UUID_BATTERY_LEVEL_STATE_CHAR, batteryCharge, sizeof(batteryCharge), sizeof(batteryCharge), 
                            GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY|GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ);

GattCharacteristic batteryPowerState(GattCharacteristic::UUID_BATTERY_POWER_STATE_CHAR, batteryState, sizeof(batteryState), sizeof(batteryState), 
                            GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE_WITHOUT_RESPONSE|
                            GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE);                            
                            

GattCharacteristic *batteryChars[] = {&batteryChargeChar, &batteryPowerState};
UUID BATTERY_SERVICE(GattService::UUID_BATTERY_SERVICE);
GattService batteryService(BATTERY_SERVICE, batteryChars, sizeof(batteryChars) / sizeof(GattCharacteristic *));


static const uint16_t uuid16_list[] = {GattService::UUID_HEART_RATE_SERVICE, GattService::UUID_GLUCOSE_SERVICE, GattService::UUID_BATTERY_SERVICE};

    
void disconnectionCallback(Gap::Handle_t handle)
{
    DEBUG("Disconnected!\n\r");
    DEBUG("Restarting the advertising process\n\r");
    dev.startAdvertising();
}

void onWriteCallback(uint16_t attributeHandle) {
    DEBUG("Write Callback!!\n\r");
    }
    
void onConnectionCallback(Gap::Handle_t handle) {
    //myled = 1; // LED is ON
    DEBUG("Connected BlueNRG!!\n\r");
    }

void Append128bitUUID(uint8_t *array, const LongUUID_t SERVICE_UUID_128) 
{
    for(int x=0;x<16; x++)
    {
        array[x+UUID_Count*16]=SERVICE_UUID_128[x];
        }
    UUID_Count++;
    return; 
}

/**
* Triggered periodically by the 'ticker' interrupt; updates hrmCounter.
*/
void periodicCallback(void)
{
    //myled = !myled; /* Do blinky on LED1 while we're waiting for BLE events */
     
    if (dev.getGapState().connected) {
        hrmCounter++;
        if (hrmCounter == 175) {
            hrmCounter = 100;
        }
        bpm[1] = hrmCounter;
        //uint16_t t = sizeof(bpm);
        //DEBUG("Char Handle 0x%x OK.",hrmRate.getHandle());
        //dev.readCharacteristicValue(hrmRate.getHandle(), bpm, (uint16_t *const)t);
        dev.updateCharacteristicValue(hrmRate.getHandle(), bpm, sizeof(bpm));
            
        bloodPressure[0] = hrmCounter;
        dev.updateCharacteristicValue(bpMeasurment.getHandle(), bloodPressure, sizeof(bloodPressure));
        //DEBUG("Ticker CB..\n\r");
        
        batteryValue++;
        batteryCharge[0] = (batteryValue+100)%100;
        dev.updateCharacteristicValue(batteryChargeChar.getHandle(), batteryCharge, sizeof(batteryCharge));
    } //else DEBUG("Not Connected..\n\r");
}

void multipleServiceUseCase() {
    Ticker ticker; //For Tick interrupt if used later on (periodic data updates?)
    
    
    //LongUUID_t HEART_RATE_CHAR_UUID_128, HRM_SERVICE_UUID_128;
    //COPY_HRM_SERVICE_UUID(HRM_SERVICE_UUID_128);
    //COPY_HRM_CHAR_UUID(HEART_RATE_CHAR_UUID_128); 
    UUID heart_rate_char_UUID = UUID(HEART_RATE_CHAR_UUID_128);
    UUID hrm_service_UUID = UUID(HRM_SERVICE_UUID_128);
    
    myled = 0;//Switch OFF LED1
     
    DEBUG("Initializing BlueNRG...\n\r");
#if 0
    SPI spi(PA_7, PA_6, PA_5); // mosi, miso, sclk
    DigitalOut cs(PB_6);
    cs = 0;
#endif    
    dev.init();
    
    dev.onConnection(onConnectionCallback);
    dev.onDisconnection(disconnectionCallback);
    dev.onDataWritten(onWriteCallback);
    
    //TODO.
    //dev.setAddress(Gap::ADDR_TYPE_PUBLIC, device_address);//Does not work after gap/gatt init.
    //TODO.    
    
    //Append128bitUUID(uuid128_list, HRM_SERVICE_UUID_128);
    
    /* setup advertising */
    dev.accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);
    
    //TODO:IMP STUFF: 128bit list is basically a uint8_t list. User should know how many services he supports and define the number in MAX_SERVICES_NOS
    dev.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS, (uint8_t*)uuid16_list, sizeof(uuid16_list));
    
    dev.accumulateAdvertisingPayload(GapAdvertisingData::HEART_RATE_SENSOR_HEART_RATE_BELT);
    
    dev.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));
    dev.setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    dev.setAdvertisingInterval(160); /* 100ms; in multiples of 0.625ms. */
    DEBUG("Starting Advertising...\n\r");
    dev.startAdvertising();
 
  
    dev.addService(bpService);  
    dev.addService(hrmService);         
    dev.addService(batteryService);
   
    
    //ticker.attach(periodicCallback, 1); Multi threading and called from ISR context does not work!
    
    while(1) {
        myled = 1; // LED is ON
        wait(0.5); // 500 ms
        myled = 0; // LED is OFF
        wait(0.5); // 500 ms
        //DEBUG("tic!\n\r");
        periodicCallback();//Works from here!!
    
        dev.waitForEvent();
    }    
}

