#include "mbed.h"
#include "waves.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"
#include "DebugTrace.h"

EthernetNetIf eth (IpAddr(192,168,1,101), IpAddr(255,255,255,0), IpAddr(192,168,1,1), IpAddr(195,50,140,246));
//EthernetNetIf eth; //for DHCP
HTTPServer svr;

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);
LocalFileSystem fs("local");
DebugTrace file(ON, TO_FILE);    // i.e. file(ON, TO_FILE, "log.txt", 1024)

float combind;

bool Check_earth();
void Motor_run();
void Play_music(int track);
void Play_Eine_kleine_Nachtmusik();
void Play_5th_Symphonie();
// Play_Note(welche Note, welchen Länge, gebunden, Lautstärke, welches Instrument)
void Play_Note(float note, float lengh, bool combine, float loud, int instrument);
void Play_Pause(float lengh);
void Play_ladder();
float Check_loud();
int val = 122;
float fval = 1.414;


int main() {
    bool too_low;
    Base::add_rpc_class<AnalogIn>();
    Base::add_rpc_class<AnalogOut>();
    Base::add_rpc_class<DigitalIn>();
    Base::add_rpc_class<DigitalOut>();
    Base::add_rpc_class<PwmOut>();
    Base::add_rpc_class<Timer>();
    Base::add_rpc_class<SPI>();
    Base::add_rpc_class<BusOut>();
    Base::add_rpc_class<BusIn>();

    EthernetErr ethErr = eth.setup();
    if (ethErr) {
        printf("Error %d in setup.\n", ethErr);
        return -1;
    }

    FSHandler::mount("/local", "/files"); //Mount /webfs path on /files web path
    FSHandler::mount("/local", "/"); //Mount /webfs path on web root path
    svr.addHandler<SimpleHandler>("/hello");
    svr.addHandler<RPCHandler>("/rpc");
    svr.addHandler<FSHandler>("/files");
    svr.addHandler<FSHandler>("/"); //Default handler
    //Example : Access to mbed.htm : http://a.b.c.d/mbed.htm or http://a.b.c.d/files/mbed.htm
    IpAddr(192,168,1,101);
    
    svr.bind(80);

    while (1) {
        Net::poll();
        too_low = Check_earth();
        combind = 0;
        if (too_low == true) {
            Motor_run();
            myled1 = true;
            Play_music(0);
        } else {
            myled1 = false;
            Play_music(1);

        }
        myled2 = false;
        file.traceOut("Test message\r\n");
        file.traceOut("%x \r\n", val);
        file.traceOut("%d \r\n", val);
        file.traceOut("%f \r\n", fval);
    }
}

bool Check_earth() {
    float TRAY = 0.3;
    bool plant = false;
    AnalogIn  plant_(p20);
    //Einlesen = der Messwert
    if (plant_ > TRAY | plant_ == 0) {
        plant = true;
    }
    //Sollte ein Messwert <= TRAY sein, Pflanze zu trocken, muss die Pumpe anlaufen
    if (plant == false) {
        myled3 = true;
        return true;
    } else {
        myled3 = false;
        return false;
    }
}

void Motor_run() {
    DigitalOut motor(p14);
    motor = true;
    wait(0.2);
    motor = false;
}

void Play_music(int track) {
    if (track == 0) {
        Play_Eine_kleine_Nachtmusik();
    }
    if (track == 1) {
        Play_5th_Symphonie();
        //Play_ladder();
    }
}

void Play_Note(float note, float lengh, bool combine, float loud, int instrument) {
    int point_read;
    float lengh_index;
    long index;
    long index1;
    long index2;
    char* text;
    char* text2;
    float add;
    AnalogOut aout(p18);

    switch (instrument) { //what instrument, read number of points of Form of Instument, if not set 0
        case 1:
            point_read = Instrument1_;
            text = "Instrument1_";
            break;
        case 2:
            point_read = Instrument2_;
            text = "Instrument2_";
            break;
        case 3:
            point_read = Instrument3_;
            text = "Instrument3_";
            break;
        case 4:
            point_read = Instrument4_;
            text = "Instrument4_";
            break;
        case 5:
            point_read = Instrument5_;
            text = "Instrument5_";
            break;
        case 6:
            point_read = Instrument6_;
            text = "Instrument6_";
            break;
        case 7:
            point_read = Instrument7_;
            text = "Instrument7_";
            break;
        case 8:
            point_read = Instrument8_;
            text = "Instrument8_";
            break;
        case 9:
            point_read = Instrument9_;
            text = "Instrument9_";
            break;
        case 10:
            point_read = Instrument10_;
            text = "Instrument10_";
            break;
        case 11:
            point_read = Instrument11_;
            text = "Instrument11_";
            break;
        case 12:
            point_read = Instrument12_;
            text = "Instrument12_";
            break;
        case 13:
            point_read = Instrument13_;
            text = "Instrument13_";
            break;
        case 14:
            point_read = Instrument14_;
            text = "Instrument14_";
            break;
        case 15:
            point_read = Instrument15_;
            text = "Instrument15_";
            break;
        case 16:
            point_read = Instrument16_;
            text = "Instrument16_";
            break;
        case 17:
            point_read = Instrument17_;
            text = "Instrument17_";
            break;
        default:
            point_read = 0;
            text = "";
            break;
    } //end switch

    lengh_index = (1/(note * point_read))*100;

    for (index = 0; index < lengh; ++index) { //as long the tone up to 1s
        add = Check_loud();
        if (combind == 0) { //no combine
            myled2 = true;
            for (index1 = 0; index1 < point_read;++index1) { //upper wave
                text = text + char(index1);
                wait(lengh_index);
                aout = 0.5 + (*text * (loud - add) * 0.5);
                if (*text == 1) {
                }
            }
            for (index2 = 0; index2 < point_read; ++index2) { //lower wave
                text = text + char(index2);
                wait(lengh_index);
                aout = 0.5 - (*text * (loud - add) * 0.5);
                if (*text == 1) {
                }
            }
            myled2 = false;
        } else {
            myled3 = true;
            for (index1 = 0; index1 < point_read;++index1) { //upper wave
                text = text + char(index1);
                text2 = text + char(index1 - 1);
                wait(lengh_index);
                aout = 0.5 + ((*text + *text2) * 0.5 * (loud - add) * 0.5);
                if (*text == 1) {
                }
            }
            for (index2 = 0; index2 < point_read; ++index2) { //lower wave
                text = text + char(index2);
                text2 = text + char(index1 - 1);
                wait(lengh_index);
                aout = 0.5 - ((*text + *text2) * 0.5 * (loud - add) * 0.5);
                if (*text == 1) {
                }
            }
            myled3 = false;
            combind = 0; //combine clear
        }
    }
    if  (combine == true) { // next combine set
        combind = note;
    }
}

void Play_Pause(float lengh) {
    AnalogOut aout(p18);

    myled4 = true;
    aout = 0.5;
    wait(lengh);
    myled4 = false;
}

float Check_loud() {
    DigitalIn up(p5);
    DigitalIn down(p6);
/*    while (up.read == 0 | index < 10000 */

            return 0;
        }