#include "mbed.h"
#include "ble/BLE.h"
#include "Sensors/Sensors.h"

#define APP_SPECIFIC_ID_TEST 0xFEFE

#pragma pack(1)
struct ApplicationData_t {
    uint16_t applicationSpecificId;             /* An ID used to identify temperature value
                                                   in the manufacture specific AD data field */
    Sensors::tmpSensorValue_t tmpSensorValue;   /* User defined application data */
};
#pragma pack()

BLE ble;
Sensors tempSensor;
DigitalOut led_r(P0_20);
DigitalOut buzzer(P0_22);
InterruptIn btn(P0_28);
InterruptIn btn1(P0_29);
static bool triggerTempValueUpdate = false;
static bool start_flag = false;
const static char   DEVICE_NAME[8] = "Linkab";   /*The size of the DEVICE_NAME[] can't change  */

void periodicCallback(void)
{
    /* Do blinky on LED1 while we're waiting for BLE events */
    triggerTempValueUpdate = true;
}

void accumulateApplicationData(ApplicationData_t &appData)
{
    appData.applicationSpecificId = APP_SPECIFIC_ID_TEST;
    /* Read a new data value */
    appData.tmpSensorValue = tempSensor.get();
}

void temperatureValueAdvertising(void)
{ 
    ApplicationData_t appData;
    
    accumulateApplicationData(appData);
    
    /* Setup advertising payload */
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE); /* Set flag */
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::GENERIC_THERMOMETER); /* Set appearance */
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::MANUFACTURER_SPECIFIC_DATA, (uint8_t *)&appData, sizeof(ApplicationData_t)); /* Set data */
    /* Setup advertising parameters */
    ble.gap().setAdvertisingType(GapAdvertisingParams::ADV_NON_CONNECTABLE_UNDIRECTED);
    ble.gap().setAdvertisingInterval(300);
    /* Start advertising */
    ble.gap().startAdvertising();
}

void updateSensorValueInAdvPayload(void)
{
    ApplicationData_t appData;
    
    accumulateApplicationData(appData);
    
    /* Stop advertising first */
    ble.gap().stopAdvertising();
    /* Only update data value field */
    ble.gap().updateAdvertisingPayload(GapAdvertisingData::MANUFACTURER_SPECIFIC_DATA, (uint8_t *)&appData, sizeof(ApplicationData_t));
    /* Start advertising again */
    ble.gap().startAdvertising();
}

void start_mode(void)
{
    led_r=0;
    wait(0.2);
    led_r=1;
    wait(0.2);
    led_r=0;
    wait(0.2);
    led_r=1;   
    ble.gap().startAdvertising();
}
void stop_mode(void)
{
    led_r=0;
    wait(0.5);
    led_r=1;
    wait(0.5);
    led_r=0;
    wait(0.5);
    led_r=1;
    ble.gap().stopAdvertising();
}

void change_startmode(void)
{

    start_flag=!start_flag;
    if(start_flag==true) 
    {
        start_mode();    
    }
    else
    {
        stop_mode();    
    }
    printf("The state is %d\n",start_flag);
}


int main(void)
{
    Ticker ticker;
    ticker.attach(periodicCallback,300);
    ble.init();
    led_r=1;
    buzzer=0;
    temperatureValueAdvertising();
    btn.fall(&change_startmode);
    btn1.fall(&updateSensorValueInAdvPayload);
    printf("This is a test!\n");
    while(true)
    {
         if(start_flag==true) 
         {
            if (triggerTempValueUpdate) 
            {
                updateSensorValueInAdvPayload();
                triggerTempValueUpdate = false;
            }
            ble.waitForEvent();
         }
        else 
        {
           ble.gap().stopAdvertising();
           ble.waitForEvent();
        }
     }
}
