#include "mbed.h"
#include "ble/BLE.h"
#include "Sensors/Sensors.h"

#define APP_SPECIFIC_ID_TEST 0xFEFE

#pragma pack(1)
struct ApplicationData_t {
    uint16_t applicationSpecificId;             /* An ID used to identify temperature value
                                                   in the manufacture specific AD data field */
    Sensors::tmpSensorValue_t tmpSensorValue;   /* User defined application data */
};
#pragma pack()

BLE ble;
Sensors tempSensor;
DigitalOut led(P0_20);
static bool triggerTempValueUpdate = false;
const static char   DEVICE_NAME[8] = "ls_test";   /*The size of the DEVICE_NAME[] can't change  */

void periodicCallback(void)
{
    /* Do blinky on LED1 while we're waiting for BLE events */
    led = !led;
    triggerTempValueUpdate = true;
}

void accumulateApplicationData(ApplicationData_t &appData)
{
    appData.applicationSpecificId = APP_SPECIFIC_ID_TEST;
    /* Read a new data value */
    appData.tmpSensorValue = tempSensor.get();
}

void temperatureValueAdvertising(void)
{ 
    ApplicationData_t appData;
    
    accumulateApplicationData(appData);
    
    /* Setup advertising payload */
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE); /* Set flag */
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::GENERIC_THERMOMETER); /* Set appearance */
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::MANUFACTURER_SPECIFIC_DATA, (uint8_t *)&appData, sizeof(ApplicationData_t)); /* Set data */
    /* Setup advertising parameters */
    ble.gap().setAdvertisingType(GapAdvertisingParams::ADV_NON_CONNECTABLE_UNDIRECTED);
    ble.gap().setAdvertisingInterval(500);
    /* Start advertising */
    ble.gap().startAdvertising();
}

void updateSensorValueInAdvPayload(void)
{
    ApplicationData_t appData;
    
    accumulateApplicationData(appData);
    
    /* Stop advertising first */
    ble.gap().stopAdvertising();
    /* Only update data value field */
    ble.gap().updateAdvertisingPayload(GapAdvertisingData::MANUFACTURER_SPECIFIC_DATA, (uint8_t *)&appData, sizeof(ApplicationData_t));
    /* Start advertising again */
    ble.gap().startAdvertising();
}

int main(void)
{
    Ticker ticker;
    /* Enable trigger every 2 seconds */
    ticker.attach(periodicCallback, 2);

    ble.init();
    /* Start data advertising */
    temperatureValueAdvertising();
    
    while (true) {
        if (triggerTempValueUpdate) 
        {
            /* Update data value */
            updateSensorValueInAdvPayload();
            triggerTempValueUpdate = false;
        }
        ble.waitForEvent();
    }
}
