#include <stdio.h>
#include "mbed.h"
#include "BMP180.h"

Serial pc(P0_23,P0_25);
DigitalOut led(P0_20);
I2C i2c(P0_17, P0_18);
BMP180 bmp180(&i2c);

int main(void) 
{
    led=0;
    while(1) 
    {
        if (bmp180.init() != 0) 
        {
            printf("Error communicating with BMP180\n");
            wait(1);
        } 
        else 
        {
            printf("Initialized BMP180\n");
            break;
        }
        wait(1);
    }

    while(1) 
    {
        bmp180.startTemperature();
        wait_ms(5);     // Wait for conversion to complete
        float temp;
        if(bmp180.getTemperature(&temp) != 0) 
        {
            printf("Error getting temperature\n");
            continue;
        }
        bmp180.startPressure(BMP180::ULTRA_LOW_POWER);
        wait_ms(10);    // Wait for conversion to complete
        int pressure;
        if(bmp180.getPressure(&pressure) != 0) 
        {
            printf("Error getting pressure\n");
            continue;
        }

        printf("Pressure = %d Pa Temperature = %f C\n", pressure, temp);
        wait(1);
    }
}