
#include "mbed.h"

#include "X_NUCLEO_NFC01A1.h"
#include "NDefLib/NDefNfcTag.h"
#include "NDefLib/Message.h"
#include "NDefLib/RecordType/RecordURI.h"
Serial pc(SERIAL_TX, SERIAL_RX);
DigitalOut myled(LED1);
InterruptIn interrupt(D12);
/**
 * Write a Ndef URI message linking to st.com site.
 */
 
 
class WriteUriCallbacks : public NDefLib::NDefNfcTag::Callbacks{
 
    DigitalOut &mOnOpenSession;
    DigitalOut &mOnWrite;
    DigitalOut &mOnCloseSession;
 
public:
 
    /**
     * create the callback chain
     * @param onOpenSession led to switch on when the session open
     * @param onWrite led to switch on when the write end
     * @param onCloseSession led to switch on when the session end
     */
    WriteUriCallbacks(DigitalOut &onOpenSession,DigitalOut &onWrite,
            DigitalOut &onCloseSession):mOnOpenSession(onOpenSession),
                    mOnWrite(onWrite),mOnCloseSession(onCloseSession){};
 
    /**
     * crate the new message and write it
     * @param tag tag where write the message
     * @param success true if the session correctly open
     */
    virtual void onSessionOpen(NDefLib::NDefNfcTag *tag,bool success){
        if(!success){
            printf("Error opening the session\r\n");
        }//else
        printf("Session opened\r\n");
        //ask to have an interrupt when the command finish
        mOnOpenSession=1;
        NDefLib::Message msg;
 
        NDefLib::RecordURI rUri(NDefLib::RecordURI::HTTP_WWW,"http://www.st.com");
        msg.addRecord(&rUri);
 
        tag->write(msg);
    }
 
    /**
     * request to close the session
     * @param tag tag where close the session
     * @param success true if the message is correctly wrote
     * @param message wrote
     */
    virtual void onMessageWrite(NDefLib::NDefNfcTag *tag,bool success,
            const NDefLib::Message&){
 
        if(!success)
            printf("Error writing tag!\r\n");
        else{
            printf("Tag written!\r\n");
            mOnWrite=1;
        }//if-else
        tag->closeSession();
    }
 
    /**
     * switch on the led
     * @param tag where the session is closed
     * @param success true if the session is correctly close
     */
    virtual void onSessionClose(NDefLib::NDefNfcTag*,bool success){
        if(success){
            printf("Error closing the session\r\n");
            mOnCloseSession=1;
        }else
            printf("Error opening the session\r\n");
    }
 
};
 
/** variable set to true when we receive an interrupt from the nfc component*/
static bool nfcInterruptFlag;
 
/** Nfc ISR called when the nfc component has a message ready*/
static void nfcInterruptCallback(){
    nfcInterruptFlag=true;
}//nfcInterruptCallback
 
void init(){
    pc.baud(115200);
    pc.format(8,SerialBase::None, 1);
}
 
void tagDetect(){
    pc.printf("Detected !!! \n");
} 
int main(int argc,char *args[]){
    (void)argc; (void)args;
 
    //create the nfc component
    I2C i2cChannel(X_NUCLEO_NFC01A1::DEFAULT_SDA_PIN,X_NUCLEO_NFC01A1::DEFAULT_SDL_PIN);
    X_NUCLEO_NFC01A1 *nfcNucleo = X_NUCLEO_NFC01A1::Instance(i2cChannel,&nfcInterruptCallback,
            X_NUCLEO_NFC01A1::DEFAULT_GPO_PIN,X_NUCLEO_NFC01A1::DEFAULT_RF_DISABLE_PIN,
            X_NUCLEO_NFC01A1::DEFAULT_LED1_PIN,X_NUCLEO_NFC01A1::DEFAULT_LED2_PIN,
            X_NUCLEO_NFC01A1::DEFAULT_LED3_PIN);
 
    //No call back needed since default behavior is sync
    nfcNucleo->getM24SR().GetSession();
    nfcNucleo->getM24SR().ManageI2CGPO(I2C_ANSWER_READY); //switch to async mode
 
    NDefLib::NDefNfcTag &tag = nfcNucleo->getM24SR().getNDefTag();
    printf("System Init done!\n\r");
 
    //crate the callback to use for write a tag
    WriteUriCallbacks NDefCallback(nfcNucleo->getLed1(),nfcNucleo->getLed2(),nfcNucleo->getLed3());
    tag.setCallback(&NDefCallback); //set the callback
    tag.openSession(); //start the callback chain
 
    printf("Start Main Loop\n\r");
    while(true){
        if(nfcInterruptFlag){
            nfcInterruptFlag=false;
            //manage an async event from the nfc component
            nfcNucleo->getM24SR().ManageEvent();
 
        }//if
        __WFE();
    }//while
 
    //return 0;
}