#ifndef CANON_H
#define CANON_H
 
#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** Canon.h
* @brief Defines variables and methods for the Canon.
* @author Helios A. Lyons
* @date April, 2020
*/
 
class Canon
{
public:
 
    Canon();
    ~Canon(); // destructor
    
    void init(int x,int height,int width);
    void draw(N5110 &lcd);
    void update(Direction d,float mag);
    // int add_total_kills(); –– replaced by adding individual type kills
    
    /** Increment Invader 1 Kills
    * @param increase kills by 1 for Invader 1
    */
    int add_inv1_kill(int n); // invader type 1 (first row)
    
    /** Increment Invader 2 Kills
    * @param increase kills by 1 for Invader 2
    */
    int add_inv2_kill(int n);
    
    /** Increment Invader 3 Kills
    * @param increase kills by 1 for Invader 3
    */
    int add_inv3_kill(int n);
    
    /** Increment Boss Kills
    * @param increase kills by 1 for Boss mobs
    */
    int add_boss_kill(); // seperate for different boss levels? narrative structure?
    
    /** Get total kills
    * @return total kills by adding invader subtype kills
    */
    int get_total_kill();
    
    /** Get the score
    * @return current score based on current kills 
    */
    int get_score();
    
    /** Get the position
    * @return current Canon position based on direction
    */
    Vector2D get_pos();
    
    /** Get remaining lives
    * @return current lives remaining
    */
    int get_life();
    
    /** Remove a life
    * @param decrease number of lives by 1
    */
    int remove_life();
    
    /** Reset lives
    * @param reset lives to 3
    */
    int reset_life();
 
private:

    int _height;
    int _width;
    int _x;
    int _y;
    int _speed;
    int _score;
    int _inv1_kill;
    int _inv2_kill;
    int _inv3_kill;
    int _boss_kill;
    int _total_kill;
    int _life;
 
};
#endif