#include "Canon.h"
#include "Bitmap.h"
#include <vector>

Canon::Canon()
{
 
}
 
Canon::~Canon()
{
 
}
 
void Canon::init(int y,int height,int width)
{
    _y = y;  // y value on screen is fixed
    _x = WIDTH/2 - width/2; // x depends on width of screen and width of canon
    _height = height;
    _width = width;
    _speed = 1;  // init speed, add in options – accessible?
    _score = 0;  // start all at 0
    _inv1_kill = 0;
    _inv2_kill = 0;
    _inv3_kill = 0;
    _total_kill = 0;
    _life = 3;
}
 
void Canon::draw(N5110 &lcd)
{
    // draw canon in screen buffer – need to replace with a different shape
    //lcd.drawRect(_x,_y,_width,_height,FILL_BLACK);
    static int sprite_data[] = {
    0,0,0,1,1,0,0,0,
    0,0,0,1,1,0,0,0,
    1,1,1,1,1,1,1,1,
    1,1,1,1,1,1,1,1 
    };
    Bitmap canon_sprite(sprite_data, 8, 4);
    canon_sprite.render(lcd, _x,_y);
}
 
void Canon::update(Direction d,float mag)
{
    _speed = int(mag*10.0f);  // scale is arbitrary, could be changed in future – add in options menu
 
    // update x value based on direction
    // North is decrement as origin is at the top-left so decreasing moves up
    if (d == W) {
        _x-=_speed;
    } else if (d == E) {
        _x+=_speed;
    }
 
    // check the x origin to set boundaries
    if (_x < 1) {
        _x = 1;
    }
    if (_x > WIDTH - _width - 1) {
        _x = WIDTH - _width - 1;
    }
}
 
int Canon::add_inv1_kill(int n)
{
    _inv1_kill = _inv1_kill + n;
    return _inv1_kill;
}

int Canon::add_inv2_kill(int n)
{
    _inv2_kill = _inv2_kill + n;
    return _inv2_kill;
}

int Canon::add_inv3_kill(int n)
{
    _inv3_kill = _inv3_kill + n;
    return _inv3_kill;
}

int Canon::add_boss_kill()
{
    _boss_kill++;
    return _boss_kill;
}

int Canon::get_total_kill()
{
    _total_kill = _inv1_kill + _inv2_kill + _inv3_kill + _boss_kill;
    return _total_kill;
}

int Canon::get_score()
{
    _score = (_inv1_kill * 10) + (_inv2_kill * 20) + (_inv1_kill * 30) + (_boss_kill * 100);
    return _score;
}
 
Vector2D Canon::get_pos() {
    Vector2D p = {_x,_y};
    return p;
}

int Canon::get_life()
{
    return _life;
}

int Canon::remove_life()
{
    _life--;
    return _life;
}

int Canon::reset_life()
{
    _life = 3;
    return _life;
}