#include "mbed.h"
#include "Serial_Transport.h"
#include "PID_Controller.h"
#include "MOTOR_CONTROL_CLASS.h"
#define pid_p 100
#define pid_i 10
#define pid_d 1
#define pid_k 10
#define PWM_PERIOD 0.01f //10ms ,100Hz
#define PWM_WIDTH_RATIO 0.00f  

DigitalOut myled(LED1);
//Serial pc(SERIAL_TX, SERIAL_RX); 
unsigned char recv_buff[100];
Serial pc(SERIAL_TX, SERIAL_RX);

int main() {
    
    pc.baud(115200);
    
    //是否有新的预设置位置
    unsigned char hasrecv_position;
    //预设置位置值
    unsigned int preset_value=0; 
    //实际位置值
    unsigned int actual_value=0;
    
    //PID输出值
    int controll_value=0;
    
    //串口屏通讯对象指针
    Serial_class * preset_Com;
    //创建实例
    preset_Com=new Serial_class(D1,D0);
    
    //摄像头通讯对象
    Serial_class * pOpenmv_Com;
    //创建实例
    pOpenmv_Com=new Serial_class(D5,D4);
    
    //声明并创建PID对象
    Ball_PID * ball_pid=new Ball_PID(pid_p,pid_i,pid_d,pid_k);
    
    //创建PWM对象     
    Motor_Control_Class mypwmout(D10);
    mypwmout.Set_Para(PWM_PERIOD,PWM_WIDTH_RATIO);//10ms ,100Hz
      
    while(1) {
//        myled = 1;
//        wait(0.2);
//        myled = 0;
//        wait(0.2);
        
         //pc.printf("data is received succesfully");      
        //读取串口屏对象接收的数据
        hasrecv_position=preset_Com->HasRecv();
        pc.printf("state=%d\n",hasrecv_position);
        if(hasrecv_position==4)
       {
           //收到完整的信息,位置值
           preset_value=preset_Com->ReadInfor();
           pc.printf("value=%d",preset_value);
           //pc.printf("data is received succesfully");
       }
//        
//        //
//        //读取OPENMV对象接收的数据
//        hasrecv_position=pOpenmv_Com->HasRecv();
//        if(hasrecv_position==1)
//        {
//           //收到完整的信息,位置值
//           actual_value=pOpenmv_Com->ReadInfor();
//           
//        }
//        
//        //交给PID模块处理,获得控制量
//        controll_value=ball_pid->PID_Calculation(preset_value,actual_value/2);
//        
//        //转换为占空比并输出
//        mypwmout.Set_Output(controll_value);
//        //        
       wait(0.5);
           
    }
}


