//#include "mbed.h"
#include "Serial_Transport.h"

//Serial pc(SERIAL_TX, SERIAL_RX);

//串口通讯子程序

//设置环形数组结构


//设计，
//写入数据：当接受到数据时，若Write_Index==Read_Index,表示数组已满，不能写入，需等待读出。若不相等，则写入Write_Index开始的数组，每完成一个字符的写入，Write_Index加1后取余为新的Write_Index。若Write_Index==Read_Index,则表示队列已满，溢出。
//读取数据：从数组的Read_Index开始读取数据，若Read_Index==Tail_Index，表示数组的数据为空（或已读完），停止读出。若不相等，则读一个字符，然后Read_Index加1后取余为新的Read_Index。

//相关程序
//声明环形数组

//extern Serial openmv_port(D5, D4); 
//extern Serial pc(SERIAL_TX, SERIAL_RX);

//Circle_Struct  circle_Struct;

//unsigned char state=0;
//unsigned char count; 

//对环形数组的操作
//判断是否为空
unsigned char Serial_class::HasRecv(void)
{
  //
    //return infor_struct.state==(4?1:0);
   return infor_struct.state ;
  //
}


//////////////////////////////////////////////////////////////
//数据接收：
void Serial_class::Add_Char(char recv)
{
  //  
  switch(infor_struct.state)
  {
    
    case 0: //判断是否是帧头1
        infor_struct.count=0; 
        if(recv==0x99)
           infor_struct.state=1; 
         break;
   case 1: //判断是否是帧头2
       if(recv==0x24)
         {
            infor_struct.state=2;
            infor_struct.count=0;  //信息部分计数器初始化
            infor_struct.value=0;
        }  
        else
        {
           //错误，
           if(recv!=0x99)
             infor_struct.state=0;
        }
       break;
   case 2: //信息部分,存入数组         
          //是否是字符串结束符
          if(recv==0x0d)
          {
            //           
            infor_struct.state=3;
            
          }  
         else
         {
            infor_struct.recv_buff[infor_struct.count]=recv;             
            infor_struct.value*=10;
            infor_struct.value+=(recv-0x30);
            infor_struct.count++;             
         }
         break;
   case 3: //wait for 0x0a
         if(recv==0x0a)
         {
            infor_struct.state=4;
         }
         else
            infor_struct.state=0;
         break;
  }  
}


//采用中断方式接收串口信息，设置中断处理函数
void Serial_class::Do_Recv()
{
    
  //临时存储接收的字符串
    char buff[1]; 
    //char tem;
    int size,size_p;
    unsigned char i;       
   
    //调试用        
    
      if(this->s_port->readable()) 
      {
       //
       size=this->s_port->read(buff,1);     
       this->s_port->write(buff,1);
       
       //rw_mutex.lock();
       
       //for(i=0;i<size;i++)
       {
          //解析加入存储
         this->Add_Char(buff[0]);
          // 
        }
        //rw_mutex.unlock();
        //*/
      }   
       
     // *pled = !(*pled);
       
     
       
     //size=sprintf(this->printbuff,"thread terminal\n");
     //printtouart(this->printbuff,size);
     
}

//
void Serial_class::Do_Recv_E(UnbufferedSerial * pserial)
{
    
  //临时存储接收的字符串
    char buff[50]; 
    //char tem;
    int size,size_p;
    unsigned char i;  
     
   
    //调试用        
    
      if(pserial->readable()) 
      {
       //
       size=pserial->read(buff,1);     
       pserial->write(buff,1);
       
       //rw_mutex.lock();
       
       //for(i=0;i<size;i++)
       {
          //解析加入存储
         this->Add_Char(buff[0]);
          // 
        }
        //rw_mutex.unlock();
        //*/
      }   
       
     // *pled = !(*pled);
       
     
       
     //size=sprintf(this->printbuff,"thread terminal\n");
     //printtouart(this->printbuff,size);
     
}

//线程处理
void Serial_class::Do_Recv_T()
{
    
  //临时存储接收的字符串
    //char buff[RECV_BUFFER_SIZE]; 
    char tem;
    int size;
    sprintf(this->printbuff,"thread begin\n");
    printtouart(this->printbuff,sizeof(this->printbuff));
    //unsigned char length;
    unsigned char i;  
    //
   // pc.printf("successful");
   
    //调试用    
    while(true)
    {
      if(pc->readable()) 
      {
       //
       size=pc->read(recv_buff,20);    
       recv_buff[size+1]='\n';   
       sprintf(this->printbuff,"received char is %s\n",recv_buff);
       printtouart(this->printbuff,sizeof(this->printbuff));
       //pc->write("received char is %c",tem);
       //pc->printf("read successful\n");
       //Add_Char(tem);
       //rw_mutex.lock();
       for(i=0;i<size;i++)
       //{
          //解析加入存储
         this->Add_Char(recv_buff[i]);
          // 
        //}
        //rw_mutex.unlock();
      }   
      *pled = !(*pled);
      ThisThread::sleep_for(500);//wait(0.100); 
      //pc->printf("do recv\n");
     } 
      
     //pc->printf("thread terminal");
     sprintf(this->printbuff,"thread terminal\n");
     printtouart(this->printbuff,sizeof(this->printbuff));
     
}


//处理接收到的数据，数据在环形缓存数组内
//使用状态机，过滤出帧头，返回信息部分字符串。
//输出：pinfor表示的信息字符串，返回值表示当前处理的状态  3：表示收到一个完整的信息。
/*
unsigned char Serial_class::DealRecv( unsigned char * pinfor)
{
  //
  unsigned char result=0;
  unsigned char recv;
  //
  while(IsEmputy()==0)
  {
    result=this->Read_From(&recv);
    //
    if(result==0)  
       return state; 

  switch(state)
  {
    
    case 0: //判断是否是帧头1
        int count=0; 
        if(recv==0x99)
           state=1; 
         break;
   case 1: //判断是否是帧头2
       if(recv==0x24)
         {
            state=2;
            count=0;  //信息部分计数器初始化
        }  
       break;
   case 2: //信息部分,存入数组
         *pinfor=recv;
          //是否是字符串结束符
          if(recv==0x0a)
          {
            //           
            state=3;
          }  
        else
        {
             count++;
             pinfor++;
        }
       break;
  } 
   if(state==3)
   {
          
       break;  
   }
 }

return state;
}
*/


//构造函数
Serial_class::Serial_class(PinName ptx, PinName prx,int baud)
{   
    int size=0;
    //创建串口对象s_port
    this->s_port =new UnbufferedSerial(ptx,prx,baud);
    //设置串口参数
     
    this->s_port->format(8, BufferedSerial::None, 1); 
    //this->s_port->enable_input(true);
    //this->s_port->enable_output(true);
    //设置初始值 
    //this->Init_Infor_struct();
    this->infor_struct.state=0;
    this->infor_struct.count=0;
    this->infor_struct.value=0;
    //关联环形数组
    //this->pcircle_Struct=&circle_Struct;
    //初始化环形数组
    //Init_Circle_Struct(pcircle_Struct);  
    //pled=new DigitalOut(LED1);
    //*pled=1;    
    pc=this->s_port;  
    //
    size=sprintf(this->printbuff,  "Mbed OS version %d.%d.%d\n",
        MBED_MAJOR_VERSION,
        MBED_MINOR_VERSION,
        MBED_PATCH_VERSION);
    printtouart(this->printbuff,size);    
    
    //关联s_port串口接收中断处理程序为成员函数Do_Recv
    s_port->attach(callback(this,&Serial_class::Do_Recv),SerialBase::RxIrq);
    //s_port->attach(callback(this,(&Serial_class::Do_Recv_E,s_port)),SerialBase::RxIrq);
    //this->m_thread.start(callback(this,&Serial_class::Do_Recv));
    
    
}

/*
void Serial_class::Setcallback()
{
    //s_port->attach(callback(this->Do_Recv_E,this->s_port),SerialBase::RxIrq);
    this->s_port->attach(callback(this,&Serial_class::Do_Recv),SerialBase::RxIrq);
}
*/

//初始化
//void Serial_class::Init_Infor_struct(void)
//{
//    infor_struct.state=4;
//    infor_struct.count=0;
//    infor_struct.value=0;
//}

//析构函数
Serial_class::~Serial_class()
{
    //删除串口对象
    delete this->s_port;
    this->s_port=NULL;
    //delete this->pc;
}

//
unsigned int Serial_class::ReadInfor()
{
   unsigned char result;
   result=infor_struct.value;
   infor_struct.state=0;
   
   return result;
}

 
void Serial_class::printtouart(char * pb,unsigned char length)
{
    this->s_port->write(pb,length);
}
 

//
 
    
    

    