#include "MOTOR_CONTROL_CLASS.h"

Motor_Control_Class::Motor_Control_Class(PinName pin)
{
    m_pwmout=new PwmOut(pin);
}

Motor_Control_Class::~Motor_Control_Class()
{
    delete m_pwmout;
    m_pwmout=NULL;
}

void Motor_Control_Class::Set_Para(double period,double plus_width)
{
    this->m_period=period;
    this->m_plus_width_ratio=plus_width;
    m_pwmout->period(period);
    m_pwmout->write(plus_width);
}

//转换成占空比，并输出
void Motor_Control_Class::Set_Output(int value)
{
    //
    if(value==0)
       return;
    if(value<0) //增加占空比，（假设）
    {
       this->m_plus_width_ratio+=0.05;
       if(this->m_plus_width_ratio>=100.00) this->m_plus_width_ratio=100.0;
    }
    else
    {
       if(this->m_plus_width_ratio>0.05)  
         this->m_plus_width_ratio-=0.05;
       
    }
    
    //输出
    m_pwmout->write(this->m_plus_width_ratio);   
    //
}
    