#include "Circle_Buffer_Class.h"

Circle_Buffer_Class::Circle_Buffer_Class(int size)
{
    if(size<10) size=10;
    else if(size>50) size=50;
    this->buffer_size=size;
    this->pbuffer=new unsigned char[size];
    Init_Circle_Struct();
}

Circle_Buffer_Class::~Circle_Buffer_Class()
{
    delete this->pbuffer;
    this->pbuffer=NULL;
}

//初始化
void Circle_Buffer_Class::Init_Circle_Struct()
{
   this->Write_Index=1;
   this->Read_Index= 0;   
   this->pbuffer[0]='\0';  //第一个单元设置为结束符
       
}


//写一个数据到环形数组
unsigned char Circle_Buffer_Class::Write_To(unsigned char infor)
{
  unsigned char tem;
  unsigned char count=0;
   //下一个写入位置。保持同Read_Index的距离
  tem=(this->Write_Index+1)%this->buffer_size;  
  while(tem==this->Read_Index)
  {   
       //
       ThisThread::sleep_for(100); 
       count++;
       if(count>10) break;       
  }
  
  if(count>10) return 0;

   //赋值      
  this->pbuffer[this->Write_Index]=infor;
  //修改Write_Index，   
  this->Write_Index=tem;  
  return 1;    
}

//从环形数组读取一个数据
//返回值：0表示没有读到数据，1：读到数据
//读取的数据在*p. 
unsigned char Circle_Buffer_Class::Read_From(unsigned char *p)
{
   unsigned char result=0;
   //环形缓冲数组是否为空
   if(this->Read_Index==this->Write_Index)
  {
     //空
     return result;
  }    
   //读取值
  *p=this->pbuffer[this->Read_Index];
  //修改指针
  this->Read_Index=(this->Read_Index+1)%buffer_size;
  //设置返回值
  result=1;
  return result;
}
 