#include "mbed.h"


#define SPI_MOSI            PA_7
#define SPI_MISO            PA_6
#define SPI_SCK             PA_5
#define SPI_CS              PB_6

#define SPI_FREQUENCY       1000000


typedef union {
    uint8_t u8vals[4];
    uint32_t u32val;
    float fval;
} DataDecoder;

typedef struct {
    uint32_t timestamp;
    float acc[3];
}sensor_data_t;

void LpmsBE1_SPI_Init();
void LpmsBE1_SPI_Write(uint8_t addr, uint8_t *buf, uint8_t length);
void LpmsBE1_SPI_Read(uint8_t addr, uint8_t *buf, uint8_t length);


uint32_t uint8_to_uint32(uint8_t *pu8vals);
float uint8_to_float(uint8_t *pu8vals);

void LpmsBE1_get_timestamp(uint32_t *ts);
void LpmsBE1_get_acc(float *acc);

